% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdaltransform.R
\name{gdaltransform}
\alias{gdaltransform}
\title{gdaltransform}
\usage{
gdaltransform(
  srcfile,
  dstfile,
  coords,
  s_srs,
  t_srs,
  to,
  order,
  tps,
  rpc,
  geoloc,
  i,
  gcp,
  output_xy,
  ignore.full_scan = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{srcfile}{Character. File with source projection definition or GCP's. If not given, source projection is read from the command-line -s_srs or -gcp parameters.}

\item{dstfile}{Character. File with destination projection definition.}

\item{coords}{Matrix. A two-column matrix with coordinates.}

\item{s_srs}{Character. source spatial reference set. The coordinate systems that can be passed are anything supported by the OGRSpatialReference.SetFromUserInput() call, which includes EPSG PCS and GCSes (ie. EPSG:4296), PROJ.4 declarations (as above), or the name of a .prf file containing well known text.}

\item{t_srs}{Character. target spatial reference set. The coordinate systems that can be passed are anything supported by the OGRSpatialReference.SetFromUserInput() call, which includes EPSG PCS and GCSes (ie. EPSG:4296), PROJ.4 declarations (as above), or the name of a .prf file containing well known text.}

\item{to}{Character. "NAME=VALUE". set a transformer option suitable to pass to GDALCreateGenImgProjTransformer2().}

\item{order}{Numeric. order of polynomial used for warping (1 to 3). The default is to select a polynomial order based on the number of GCPs.}

\item{tps}{Logical. Force use of thin plate spline transformer based on available GCPs.}

\item{rpc}{Logical. Force use of RPCs.}

\item{geoloc}{Logical. Force use of Geolocation Arrays.}

\item{i}{Logical. Inverse transformation: from destination to source.}

\item{gcp}{Character. pixel line easting northing [elevation]: Provide a GCP to be used for transformation (generally three or more are required)}

\item{output_xy}{Logical. (GDAL >= 2.0) Restrict output to "x y" instead of "x y z"}

\item{ignore.full_scan}{Logical. If FALSE, perform a brute-force scan if other installs are not found.  Default is TRUE.}

\item{verbose}{Logical. Enable verbose execution? Default is FALSE.}
}
\value{
Numeric.
}
\description{
R wrapper for gdaltransform: transforms coordinates
}
\details{
This is an R wrapper for the 'gdaltransform' function that is part of the 
Geospatial Data Abstraction Library (GDAL).  It follows the parameter naming
conventions of the original function, with some modifications to allow for more R-like
parameters.  For all parameters, the user can use a single character string following,
precisely, the gdalinfo format (\url{http://gdal.org/gdaltransform.html}), or,
in some cases, can use R vectors to achieve the same end.  

This function assumes the user has a working GDAL on their system.  If the 
"gdalUtils_gdalPath" option has been set (usually by gdal_setInstallation),
the GDAL found in that path will be used.  If nothing is found, gdal_setInstallation
will be executed to attempt to find a working GDAL.
}
\examples{
# We'll pre-check to make sure there is a valid GDAL install.
# Note this isn't strictly neccessary, as executing the function will
# force a search for a valid GDAL install.
gdal_setInstallation()
valid_install <- !is.null(getOption("gdalUtils_gdalPath"))
if(valid_install)
{
pts <- matrix(c(177502,311865,177503,311866),ncol=2,byrow=TRUE)
gdaltransform(s_srs="EPSG:28992",t_srs="EPSG:31370",coords=pts,verbose=TRUE)
}
}
\references{
\url{http://www.gdal.org/gdaltransform.html}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net}) (wrapper) and Frank Warmerdam (GDAL lead developer).
}
