% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalbuildvrt.R
\name{gdalbuildvrt}
\alias{gdalbuildvrt}
\title{Interface to GDAL's gdalbuildvrt utility}
\usage{
gdalbuildvrt(gdalfile, output.vrt, ..., tileindex, resolution, te, tr, tap,
  separate, b, sd, allow_projection_difference, q, addalpha, hidenodata,
  srcnodata, vrtnodata, a_srs, r, input_file_list, overwrite,
  dryrun = FALSE)
}
\arguments{
\item{gdalfile}{Character vector supplying file paths to one or more
input datasets.}

\item{output.vrt}{Character. Path to output VRT file. Typically,
output file will have suffix \code{".vrt"}.}

\item{...}{Here, a placeholder argument that forces users to
supply exact names of all subsequent formal arguments.}

\item{tileindex, resolution, te, tr, tap, separate, b, sd}{See the GDAL
project's
\href{https://gdal.org/programs/gdalbuildvrt.html}{gdalbuildvrt
documentation} for details.}

\item{allow_projection_difference, q, addalpha, hidenodata}{See the
GDAL project's
\href{https://gdal.org/programs/gdalbuildvrt.html}{gdalbuildvrt
documentation} for details.}

\item{srcnodata, vrtnodata, a_srs, r, input_file_list, overwrite}{See
the GDAL project's
\href{https://gdal.org/programs/gdalbuildvrt.html}{gdalbuildvrt
documentation} for details.}

\item{dryrun}{Logical (default \code{FALSE}). If \code{TRUE},
instead of executing the requested call to GDAL, the function
will print the command-line call that would produce the
equivalent output.}
}
\value{
None. Called instead for its side effect.
}
\description{
This function provides an interface mirroring that of the GDAL
command-line app \code{gdalbuildvrt}. For a description of the
utility and the arguments that it takes, see the documentation at
\url{https://gdal.org/programs/gdalbuildvrt.html}.
}
\examples{
## Prepare file paths
td <- tempdir()
out_vrt <- file.path(td, "out.vrt")
layer1 <-
    system.file("external/tahoe_lidar_bareearth.tif",
                package = "gdalUtils")
layer2 <-
    system.file("external/tahoe_lidar_highesthit.tif",
                package = "gdalUtils")

## Build VRT and check that it works
gdalbuildvrt(gdalfile = c(layer1, layer2), output.vrt = out_vrt)
gdalinfo(out_vrt)
}
\author{
Joshua O'Brien
}
