% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalBindings.R
\name{createDataset}
\alias{createDataset}
\title{Creates a new GDALDataset}
\usage{
createDataset(
  raster_path,
  nbands,
  datatype,
  projstring,
  lr_lat,
  ul_lat,
  ul_lon,
  lr_lon,
  res,
  nodata,
  co = NULL
)
}
\arguments{
\item{raster_path}{Character. The output path for the raster data}

\item{nbands}{Integer. Number of bands. Default 1.}

\item{datatype}{GDALDataType. The GDALDataType to use for the raster, use (GDALDataType$)
to find the options. Default GDALDataType$GDT_Float64}

\item{projstring}{The projection string, either proj or WKT is accepted.}

\item{lr_lat}{Numeric. The lower right latitude.}

\item{ul_lat}{Numeric. The upper left latitude.}

\item{ul_lon}{Numeric. The upper left longitude.}

\item{lr_lon}{Numeric. The lower right longitude.}

\item{res}{Numeric. The resolution of the output raster}

\item{nodata}{Numeric. The no data value for the raster. Default 0.}

\item{co}{CharacterVector. A CharacterVector of creation options for GDAL. Default NULL}
}
\value{
An object from GDALDataset R6 class.
}
\description{
Create a new raster file based on specified data. It will output a *.tif file.
}
\examples{
# Parameters
raster_path <- file.path(tempdir(), "output.tif")
ul_lat <- -15
ul_lon <- -45
lr_lat <- -25
lr_lon <- -35
res <- c(0.01, -0.01)
datatype <- GDALDataType$GDT_Int32
nbands <- 1
projstring <- "EPSG:4326"
nodata <- -1
co <- c("TILED=YES", "BLOCKXSIZE=512", "BLOCKYSIZE=512", "COMPRESSION=LZW")

# Create a new raster dataset
ds <- createDataset(
  raster_path = raster_path,
  nbands = nbands,
  datatype = datatype,
  projstring = projstring,
  lr_lat = lr_lat,
  ul_lat = ul_lat,
  ul_lon = ul_lon,
  lr_lon = lr_lon,
  res = res,
  nodata = nodata,
  co = co
)

# Get the GDALRasterBand for ds
band <- ds[[1]]

# Set some dummy values
band[[0, 0]] <- 1:(512 * 512)

ds$Close()
}
