% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_ms.R
\name{find_ms}
\alias{find_ms}
\title{Finds MS}
\usage{
find_ms(data, t_peak, tolerance = 5e-04)
}
\arguments{
\item{data}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data().}

\item{t_peak}{a \emph{float} object. The overall time index value for when
the peak occurs in the GCxGC sample (the 1D time value).}

\item{tolerance}{a \emph{double} object. The tolerance allowed for the time
index. Default is 0.0005.}
}
\value{
A \emph{data.frame} object. A data frame of the mass values and the
percent intensity values.
}
\description{
\code{find_ms} Finds mass spectra of a peak.
}
\details{
This function finds the mass spectra values of a peak in the
intensity values of a GCxGC sample at a specified overall time index value.
Then outputs a data frame of the mass values and percent intensity values
which can then be plotted to product the mass spectra plot.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
peaks <- top_peaks(frame$TIC_df, 5)
mz <- find_ms(frame, t_peak=peaks$'T'[1])
plot_ms(mz)
plot_defect(mz,title="Kendrick Mass Defect, CH_2")

}
