`hanleyR` <-
function (corr, auc) 
{
    if (auc < 0.7 || auc > 0.975) {
        warning("Mean AUC ($auc) outside range of Hanley-McNeil lookup table\n")
        return(NA)
    }
    if (corr < 0.02 || corr > 0.9) {
        warning("Mean correlation ($corr) outside range of Hanley-McNeil lookup table\n")
        return(NA)
    }
    staticr = c(0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 
        0.01, 0.01, 0.01, 0.01, 0.04, 0.04, 0.03, 0.03, 0.03, 
        0.03, 0.03, 0.03, 0.03, 0.02, 0.02, 0.02, 0.05, 0.05, 
        0.05, 0.05, 0.05, 0.05, 0.05, 0.04, 0.04, 0.04, 0.03, 
        0.02, 0.07, 0.07, 0.07, 0.07, 0.07, 0.06, 0.06, 0.06, 
        0.06, 0.05, 0.04, 0.03, 0.09, 0.09, 0.09, 0.09, 0.08, 
        0.08, 0.08, 0.07, 0.07, 0.06, 0.06, 0.04, 0.11, 0.11, 
        0.11, 0.1, 0.1, 0.1, 0.09, 0.09, 0.08, 0.08, 0.07, 0.05, 
        0.13, 0.12, 0.12, 0.12, 0.12, 0.11, 0.11, 0.11, 0.1, 
        0.09, 0.08, 0.06, 0.14, 0.14, 0.14, 0.14, 0.13, 0.13, 
        0.13, 0.12, 0.11, 0.11, 0.09, 0.07, 0.16, 0.16, 0.16, 
        0.16, 0.15, 0.15, 0.14, 0.14, 0.13, 0.12, 0.11, 0.09, 
        0.18, 0.18, 0.18, 0.17, 0.17, 0.17, 0.16, 0.15, 0.15, 
        0.14, 0.12, 0.1, 0.2, 0.2, 0.19, 0.19, 0.19, 0.18, 0.18, 
        0.17, 0.16, 0.15, 0.14, 0.11, 0.22, 0.22, 0.21, 0.21, 
        0.21, 0.2, 0.19, 0.19, 0.18, 0.17, 0.15, 0.12, 0.24, 
        0.23, 0.23, 0.23, 0.22, 0.22, 0.21, 0.2, 0.19, 0.18, 
        0.16, 0.13, 0.26, 0.25, 0.25, 0.25, 0.24, 0.24, 0.23, 
        0.22, 0.21, 0.2, 0.18, 0.15, 0.27, 0.27, 0.27, 0.26, 
        0.26, 0.25, 0.25, 0.24, 0.23, 0.21, 0.19, 0.16, 0.29, 
        0.29, 0.29, 0.28, 0.28, 0.27, 0.26, 0.26, 0.24, 0.23, 
        0.21, 0.18, 0.31, 0.31, 0.31, 0.3, 0.3, 0.29, 0.28, 0.27, 
        0.26, 0.25, 0.23, 0.19, 0.33, 0.33, 0.32, 0.32, 0.31, 
        0.31, 0.3, 0.29, 0.28, 0.26, 0.24, 0.21, 0.35, 0.35, 
        0.34, 0.34, 0.33, 0.33, 0.32, 0.31, 0.3, 0.28, 0.26, 
        0.22, 0.37, 0.37, 0.36, 0.36, 0.35, 0.35, 0.34, 0.33, 
        0.32, 0.3, 0.28, 0.24, 0.39, 0.39, 0.38, 0.38, 0.37, 
        0.36, 0.36, 0.35, 0.33, 0.32, 0.29, 0.25, 0.41, 0.4, 
        0.4, 0.4, 0.39, 0.38, 0.38, 0.37, 0.35, 0.34, 0.31, 0.27, 
        0.43, 0.42, 0.42, 0.42, 0.41, 0.4, 0.39, 0.38, 0.37, 
        0.35, 0.33, 0.29, 0.45, 0.44, 0.44, 0.43, 0.43, 0.42, 
        0.41, 0.4, 0.39, 0.37, 0.35, 0.3, 0.47, 0.46, 0.46, 0.45, 
        0.45, 0.44, 0.43, 0.42, 0.41, 0.39, 0.37, 0.32, 0.49, 
        0.48, 0.48, 0.47, 0.47, 0.46, 0.45, 0.44, 0.43, 0.41, 
        0.39, 0.34, 0.51, 0.5, 0.5, 0.49, 0.49, 0.48, 0.47, 0.46, 
        0.45, 0.43, 0.41, 0.36, 0.53, 0.52, 0.52, 0.51, 0.51, 
        0.5, 0.49, 0.48, 0.47, 0.45, 0.43, 0.38, 0.55, 0.54, 
        0.54, 0.53, 0.53, 0.52, 0.51, 0.5, 0.49, 0.47, 0.45, 
        0.4, 0.57, 0.56, 0.56, 0.55, 0.55, 0.54, 0.53, 0.52, 
        0.51, 0.49, 0.47, 0.42, 0.59, 0.58, 0.58, 0.57, 0.57, 
        0.56, 0.55, 0.54, 0.53, 0.51, 0.49, 0.45, 0.61, 0.6, 
        0.6, 0.59, 0.59, 0.58, 0.58, 0.57, 0.55, 0.54, 0.51, 
        0.47, 0.63, 0.62, 0.62, 0.62, 0.61, 0.6, 0.6, 0.59, 0.57, 
        0.56, 0.53, 0.49, 0.65, 0.64, 0.64, 0.64, 0.63, 0.62, 
        0.62, 0.61, 0.6, 0.58, 0.56, 0.51, 0.67, 0.66, 0.66, 
        0.66, 0.65, 0.65, 0.64, 0.63, 0.62, 0.6, 0.58, 0.54, 
        0.69, 0.69, 0.68, 0.68, 0.67, 0.67, 0.66, 0.65, 0.64, 
        0.63, 0.6, 0.56, 0.71, 0.71, 0.7, 0.7, 0.69, 0.69, 0.68, 
        0.67, 0.66, 0.65, 0.63, 0.59, 0.73, 0.73, 0.72, 0.72, 
        0.72, 0.71, 0.71, 0.7, 0.69, 0.67, 0.65, 0.61, 0.75, 
        0.75, 0.75, 0.74, 0.74, 0.73, 0.73, 0.72, 0.71, 0.7, 
        0.68, 0.64, 0.77, 0.77, 0.77, 0.76, 0.76, 0.76, 0.75, 
        0.74, 0.73, 0.72, 0.7, 0.67, 0.79, 0.79, 0.79, 0.79, 
        0.78, 0.78, 0.77, 0.77, 0.76, 0.75, 0.73, 0.7, 0.82, 
        0.81, 0.81, 0.81, 0.81, 0.8, 0.8, 0.79, 0.78, 0.77, 0.76, 
        0.73, 0.84, 0.84, 0.83, 0.83, 0.83, 0.82, 0.82, 0.81, 
        0.81, 0.8, 0.78, 0.75, 0.86, 0.86, 0.86, 0.85, 0.85, 
        0.85, 0.84, 0.84, 0.83, 0.82, 0.81, 0.79, 0.88, 0.88, 
        0.88, 0.88, 0.87, 0.87, 0.87, 0.86, 0.86, 0.85, 0.84, 
        0.82)
    staticr <- matrix(staticr, ncol = 12, byrow = TRUE)
    aucdelta <- 0.025
    aucstart <- 0.7
    indexauc <- (auc - aucstart)/aucdelta
    indexaucl <- floor(indexauc)
    indexaucr <- ceiling(indexauc)
    diffaucl <- auc - (aucstart + (indexaucl * aucdelta))
    diffaucr <- (aucstart + (indexaucr * aucdelta)) - auc
    corrdelta <- 0.02
    corrstart <- 0.02
    indexcorr <- (corr - corrstart)/corrdelta
    indexcorrl <- floor(indexcorr)
    indexcorrr <- ceiling(indexcorr)
    diffcorrl <- corr - (corrstart + (indexcorrl * corrdelta))
    diffcorrr <- (corrstart + (indexcorrr * corrdelta)) - corr
    rll <- staticr[indexcorrl + 1, indexaucl + 1]
    rlr <- staticr[indexcorrl + 1, indexaucr + 1]
    rrl <- staticr[indexcorrr + 1, indexaucl + 1]
    rrr <- staticr[indexcorrr + 1, indexaucr + 1]
    diffaucln <- diffaucl/(diffaucl + diffaucr)
    diffaucrn <- diffaucr/(diffaucl + diffaucr)
    diffcorrln <- diffcorrl/(diffcorrl + diffcorrr)
    diffcorrrn <- diffcorrr/(diffcorrl + diffcorrr)
    weightll <- (1 - diffcorrln) * (1 - diffaucln)
    weightlr <- (1 - diffcorrln) * (1 - diffaucrn)
    weightrl <- (1 - diffcorrrn) * (1 - diffaucln)
    weightrr <- (1 - diffcorrrn) * (1 - diffaucrn)
    r <- (weightll * rll) + (weightlr * rlr) + (weightrl * rrl) + 
        (weightrr * rrr)
    return(r)
}
