% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbp4d_cpp_rd.r
\docType{class}
\name{gbp4q}
\alias{Rcpp_gbp4q}
\alias{Rcpp_gbp4q-class}
\alias{gbp4q}
\title{gbp4q}
\format{An object of class \code{C++Class} of length 1.}
\usage{
gbp4q
}
\description{
generalized bin packing problem in 4 dimension, a.k.a bin packing problem with weight limit.
}
\details{
gbp4d init a profit vector p, a length l, a depth d, a height h, and a weight w, along with
  associate constraints ml, md, mh and mw.
 gbp4d should fit it (l, d, h, w) into bn (ml, md, mh, mw) with w on weight limit constraint
  and l, d, h on geometry intepretation.
 gbp4d solver would solve

   maximize   sum_{j=1}^{n} p_{j} k_{j}

   subject to sum_{j=1}^{n} w_{j} k_{j} leq mw and

              fit (l_{j}, d_{j}, h_{j}) at coordinate (x_{j}, y_{j}, z_{j})
              such that no overlap in ml x md x mh cuboid, j = 1, ......, n

 and instantiate a gbp4d object with a x-axis coordinate vector x, a y-axis coordinate vector y,
  a z-axis coordinate vector z, a selection vector k, and an objective o.

 gbp4q solver would also select the most preferred often smallest m from a list of m(l, d, h) after
  determine all or the higest volume set of ld can fit into one m(l, d, h) w.r.t the weight constraint.

 a gbp4q class instance has 7 fields:

  - p: profit of it fit into bn <vector>

       created via cluster w via gbp1d, cluster max(l, d, h) and area via gbp4d_solver_dpp_main_create_p()

  - it: it position and scale <matrix>

    - x, y, z, w it position and w in the bin <numeric> (w hold in bn when fit it in bn)

    - l, d, h, w it scale along x, y, z and w <numeric> (w of it itself)

  - bn: bn scale <matrix>

    - l, d, h, w bn scale along x, y, z and w <numeric>

      matrix of 4 rows and each column is a single bn

    should make sure bn list are sorted via volume
     so that the first col is the most prefered smallest bn, and also
     the last col is the least prefered largest and often dominant bn

    should make sure no X in front of Y if bnX dominant bnY,
     bnX dominant bnY if all(X(l, d, h) > Y(l, d, h)) and should always prefer Y.

    should make sure bn such that l >= d or vice versa.

  - k: selection indicator 0, 1 on it <vector>

  - f: selection indicator 0, 1, 2, 3 on bn <vector>

       f in result should have no 0 and only one of 1

  - o: objective achivement volumn fit in over volumn overall <numeric>

  - ok: a quick indicator of all it fit into bn? <bool>
}
\seealso{
Other gbp4q: \code{\link{gbp4d_solver_dpp_filt}},
  \code{\link{gbp4q_checkr}}
}
\keyword{datasets}

