% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation-relative-influence.r
\name{permutation_relative_influence}
\alias{permutation_relative_influence}
\title{Relative influence via permutation}
\usage{
permutation_relative_influence(
  gbm_fit_obj,
  num_trees,
  rescale = FALSE,
  sort_it = FALSE
)
}
\arguments{
\item{gbm_fit_obj}{a \code{GBMFit} object from an initial call to
\code{\link{gbmt}}.}

\item{num_trees}{the number of trees to use for computations. If
not provided, the function will guess: if a test set was used in
fitting, the number of trees resulting in lowest test set error
will be used; otherwise, if cross-validation was performed, the
number of trees resulting in lowest cross-validation error will be
used; otherwise, all trees will be used.}

\item{rescale}{whether or not the result should be scaled. Defaults
to \code{FALSE}.}

\item{sort_it}{whether or not the results should be (reverse)
sorted.  Defaults to \code{FALSE}.}
}
\value{
By default, returns an unprocessed vector of estimated
relative influences. If the \code{rescale} and \code{sort}
arguments are used, returns a processed version of the same.
}
\description{
This function offers a method for computing the relative influence in
\code{\link{summary.GBMFit}}, and is not intended to be called directly.
}
\details{
Calculates the relative influence of predictors via random
permutation of each predictor one at a time and calculating the
associated reduction in predictive performance.  This experimental
measure is similar to the variable importance measures Breiman uses
for random forests, but \code{\link{gbmt}} currently computes using
the entire training dataset (not the out-of-bag observations).
}
\seealso{
\code{\link{summary.GBMFit}}
\href{https://www.stat.berkeley.edu/~breiman/randomforest2001.pdf}{Random
Forests}.
}
\author{
Greg Ridgeway \email{gregridgeway@gmail.com}
}
\keyword{hplot}
