% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fstepwise.R
\name{fstepwise}
\alias{fstepwise}
\title{Stepwise selection of covariates}
\usage{
fstepwise(y, x, alpha, nu = 1, kmax = 0, kexk = 0,
  intercept = TRUE, chkintercept = FALSE, misclass = FALSE)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{alpha}{The P-value cut-off}

\item{nu}{The order statistic of Gaussian covariates used for comparison}

\item{kmax}{The maximum number of included covariates}

\item{kexk}{The excluded covariates}

\item{intercept}{Logical to include intercept}

\item{chkintercept}{Logical to include or exclude intercept dependent on the P-value}

\item{misclass}{Logical The number of misclassifications if appropriate,  eg for binary y}

}
\value{
pv The selected covariates in order together with P-values, sum of squared residuals and if appropriate number of misclassifications.
}
\description{
Stepwise selection of covariates
}
\examples{
data(leukemiax)
data(leukemiay)
fstepwise(ly.original,lx.original,0.01,misclass=TRUE)
}
