% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsimords.R
\name{fsimords}
\alias{fsimords}
\title{Simulates the number of false positives for given dimensions (n,k) and given order statistics nu}
\usage{
fsimords(n, k, p0 , nu, km, nsim = 500)
}
\arguments{
\item{n}{The dimension of dependent variable}

\item{k}{The number of covariates}

\item{p0}{Cut-off p-value}

\item{nu}{The order statistics}

\item{km}{Maximum number of selected covariates}


\item{nsim}{Number of simulations}
}
\value{
p Histogram of number of false positives.

mn Mean number of false positives.

ss Standard deviation of number of false positives
}
\description{
Simulates the number of false positives for given dimensions (n,k) and given order statistics nu
}
\examples{
a<-fsimords(100,100,0.01,c(5,10),15,nsim=100)
}
