% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_gastempt.R
\name{stan_gastempt}
\alias{stan_gastempt}
\title{Fit gastric emptying curves with Stan}
\usage{
stan_gastempt(
  d,
  model_name = "linexp_gastro_2b",
  lkj = 2,
  student_df = 5L,
  init_r = 0.2,
  chains = 1,
  iter = 2000,
  ...
)
}
\arguments{
\item{d}{A data frame with columns
\itemize{
  \item \code{rec} Record descriptor as grouping variable, e.g. patient ID
  \item \code{minute} Time after meal or start of recording.
  \item \code{vol} Volume of meal or stomach
 }}

\item{model_name}{Name of predefined model in
\code{gastempt/exec}. Use \code{stan_model_names()} to get a list
of available models.}

\item{lkj}{LKJ prior for kappa/tempt correlation, only required
for model linexp_gastro_2b. Values from 1.5 (strong correlation) to 50
(almost independent) are useful.}

\item{student_df}{Student-t degrees of freedom for residual error;
default 5. Use 3 for strong outliers; values above 10 are close to gaussian
residual distribution.}

\item{init_r}{for stan, default = 0.2; Stan's own default is 2, which
often results in stuck chains.}

\item{chains}{for stan; default = 1}

\item{iter}{A positive integer specifying the number of iterations for
each chain (including warmup). The default is 2000.}

\item{...}{Additional parameter passed to \code{sampling} and \code{stan}}
}
\value{
A list of class stan_gastempt with elements \code{coef, fit, plot}
\itemize{
  \item \code{coef} is a data frame with columns:
    \itemize{
      \item \code{rec} Record descriptor, e.g. patient ID
      \item \code{v0} Initial volume at t=0
      \item \code{tempt} Emptying time constant
      \item \code{kappa} Parameter \code{kappa} for
            \code{model = linexp}
      \item \code{beta} Parameter \code{beta} for \code{model = powexp}
      \item \code{t50} Half-time of emptying
      \item \code{slope_t50} Slope in t50; typically in units of ml/minute
 On error, \code{coef} is NULL
   }
  \item \code{fit} Result of class `stanfit`
  \item \code{plot} A ggplot graph of data and prediction. Plot of raw data is
     returned even when convergence was not achieved.
 }
}
\description{
Fit gastric emptying curves with Stan
}
\examples{
\donttest{
 # Runs 30+ seconds on CRAN
 dd = simulate_gastempt(n_records = 6, seed = 471)
 d = dd$data
 ret = stan_gastempt(d)
 print(ret$coef)
 }
}
