// Generated by rstantools.  Do not edit by hand.

/*
    breathteststan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    breathteststan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with breathteststan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.19.1
#include <stan/model/model_header.hpp>
namespace model_linexp_gastro_2b_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_linexp_gastro_2b");
    reader.add_event(100, 98, "end", "model_linexp_gastro_2b");
    return reader;
}
#include <stan_meta_header.hpp>
class model_linexp_gastro_2b : public prob_grad {
private:
        double lkj;
        int student_df;
        int n;
        int n_record;
        std::vector<int> record;
        vector_d minute;
        vector_d volume;
        vector_d zeros;
        vector_d volume_1;
        double norm_vol;
        int n_norm;
public:
    model_linexp_gastro_2b(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_linexp_gastro_2b(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_linexp_gastro_2b_namespace::model_linexp_gastro_2b";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "lkj", "double", context__.to_vec());
            lkj = double(0);
            vals_r__ = context__.vals_r("lkj");
            pos__ = 0;
            lkj = vals_r__[pos__++];
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "student_df", "int", context__.to_vec());
            student_df = int(0);
            vals_i__ = context__.vals_i("student_df");
            pos__ = 0;
            student_df = vals_i__[pos__++];
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 15;
            context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
            n_record = int(0);
            vals_i__ = context__.vals_i("n_record");
            pos__ = 0;
            n_record = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_record", n_record, 0);
            current_statement_begin__ = 16;
            validate_non_negative_index("record", "n", n);
            context__.validate_dims("data initialization", "record", "int", context__.to_vec(n));
            record = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("record");
            pos__ = 0;
            size_t record_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < record_k_0_max__; ++k_0__) {
                record[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 17;
            validate_non_negative_index("minute", "n", n);
            context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
            minute = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("minute");
            pos__ = 0;
            size_t minute_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < minute_j_1_max__; ++j_1__) {
                minute(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 18;
            validate_non_negative_index("volume", "n", n);
            context__.validate_dims("data initialization", "volume", "vector_d", context__.to_vec(n));
            volume = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("volume");
            pos__ = 0;
            size_t volume_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < volume_j_1_max__; ++j_1__) {
                volume(j_1__) = vals_r__[pos__++];
            }
            // initialize transformed data variables
            current_statement_begin__ = 22;
            validate_non_negative_index("zeros", "2", 2);
            zeros = Eigen::Matrix<double, Eigen::Dynamic, 1>(2);
            stan::math::fill(zeros, DUMMY_VAR__);
            current_statement_begin__ = 23;
            validate_non_negative_index("volume_1", "n", n);
            volume_1 = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            stan::math::fill(volume_1, DUMMY_VAR__);
            current_statement_begin__ = 24;
            norm_vol = double(0);
            stan::math::fill(norm_vol, DUMMY_VAR__);
            current_statement_begin__ = 25;
            n_norm = int(0);
            stan::math::fill(n_norm, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 26;
            stan::model::assign(zeros, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable zeros");
            current_statement_begin__ = 27;
            stan::model::assign(zeros, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable zeros");
            current_statement_begin__ = 28;
            stan::math::assign(n_norm, 0);
            current_statement_begin__ = 29;
            stan::math::assign(norm_vol, 0);
            current_statement_begin__ = 31;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 32;
                if (as_bool(logical_lt(get_base1(minute, i, "minute", 1), 5))) {
                    current_statement_begin__ = 33;
                    stan::math::assign(norm_vol, (norm_vol + get_base1(volume, i, "volume", 1)));
                    current_statement_begin__ = 34;
                    stan::math::assign(n_norm, (n_norm + 1));
                }
            }
            current_statement_begin__ = 37;
            stan::math::assign(norm_vol, (norm_vol / n_norm));
            current_statement_begin__ = 38;
            stan::math::assign(volume_1, divide(volume, norm_vol));
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 43;
            validate_non_negative_index("v0_1", "n_record", n_record);
            num_params_r__ += n_record;
            current_statement_begin__ = 44;
            validate_non_negative_index("sigma_record", "2", 2);
            num_params_r__ += 2;
            current_statement_begin__ = 45;
            num_params_r__ += 1;
            current_statement_begin__ = 46;
            num_params_r__ += 1;
            current_statement_begin__ = 47;
            validate_non_negative_index("rho", "2", 2);
            validate_non_negative_index("rho", "2", 2);
            num_params_r__ += ((2 * (2 - 1)) / 2);
            current_statement_begin__ = 48;
            num_params_r__ += 1;
            current_statement_begin__ = 49;
            validate_non_negative_index("cf", "2", 2);
            validate_non_negative_index("cf", "n_record", n_record);
            num_params_r__ += (2 * n_record);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_linexp_gastro_2b() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 43;
        if (!(context__.contains_r("v0_1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable v0_1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("v0_1");
        pos__ = 0U;
        validate_non_negative_index("v0_1", "n_record", n_record);
        context__.validate_dims("parameter initialization", "v0_1", "vector_d", context__.to_vec(n_record));
        Eigen::Matrix<double, Eigen::Dynamic, 1> v0_1(n_record);
        size_t v0_1_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < v0_1_j_1_max__; ++j_1__) {
            v0_1(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, v0_1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable v0_1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 44;
        if (!(context__.contains_r("sigma_record")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_record missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_record");
        pos__ = 0U;
        validate_non_negative_index("sigma_record", "2", 2);
        context__.validate_dims("parameter initialization", "sigma_record", "vector_d", context__.to_vec(2));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_record(2);
        size_t sigma_record_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < sigma_record_j_1_max__; ++j_1__) {
            sigma_record(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sigma_record);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_record: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 45;
        if (!(context__.contains_r("mu_kappa")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_kappa missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_kappa");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu_kappa", "double", context__.to_vec());
        double mu_kappa(0);
        mu_kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, mu_kappa);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_kappa: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 46;
        if (!(context__.contains_r("mu_tempt")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_tempt missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_tempt");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu_tempt", "double", context__.to_vec());
        double mu_tempt(0);
        mu_tempt = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, mu_tempt);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_tempt: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 47;
        if (!(context__.contains_r("rho")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rho missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "2", 2);
        validate_non_negative_index("rho", "2", 2);
        context__.validate_dims("parameter initialization", "rho", "matrix_d", context__.to_vec(2,2));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> rho(2, 2);
        size_t rho_j_2_max__ = 2;
        size_t rho_j_1_max__ = 2;
        for (size_t j_2__ = 0; j_2__ < rho_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
                rho(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.corr_matrix_unconstrain(rho);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rho: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 48;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 49;
        if (!(context__.contains_r("cf")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable cf missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("cf");
        pos__ = 0U;
        validate_non_negative_index("cf", "2", 2);
        validate_non_negative_index("cf", "n_record", n_record);
        context__.validate_dims("parameter initialization", "cf", "vector_d", context__.to_vec(n_record,2));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > cf(n_record, Eigen::Matrix<double, Eigen::Dynamic, 1>(2));
        size_t cf_j_1_max__ = 2;
        size_t cf_k_0_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < cf_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < cf_k_0_max__; ++k_0__) {
                cf[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t cf_i_0_max__ = n_record;
        for (size_t i_0__ = 0; i_0__ < cf_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(cf[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable cf: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 43;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> v0_1;
            (void) v0_1;  // dummy to suppress unused var warning
            if (jacobian__)
                v0_1 = in__.vector_lb_constrain(0, n_record, lp__);
            else
                v0_1 = in__.vector_lb_constrain(0, n_record);
            current_statement_begin__ = 44;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigma_record;
            (void) sigma_record;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_record = in__.vector_lb_constrain(0, 2, lp__);
            else
                sigma_record = in__.vector_lb_constrain(0, 2);
            current_statement_begin__ = 45;
            local_scalar_t__ mu_kappa;
            (void) mu_kappa;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_kappa = in__.scalar_lb_constrain(0, lp__);
            else
                mu_kappa = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 46;
            local_scalar_t__ mu_tempt;
            (void) mu_tempt;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_tempt = in__.scalar_lb_constrain(0, lp__);
            else
                mu_tempt = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 47;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> rho;
            (void) rho;  // dummy to suppress unused var warning
            if (jacobian__)
                rho = in__.corr_matrix_constrain(2, lp__);
            else
                rho = in__.corr_matrix_constrain(2);
            current_statement_begin__ = 48;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0, lp__);
            else
                sigma = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 49;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > cf;
            size_t cf_d_0_max__ = n_record;
            cf.reserve(cf_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < cf_d_0_max__; ++d_0__) {
                if (jacobian__)
                    cf.push_back(in__.vector_constrain(2, lp__));
                else
                    cf.push_back(in__.vector_constrain(2));
            }
            // transformed parameters
            current_statement_begin__ = 53;
            validate_non_negative_index("sigma_cf", "2", 2);
            validate_non_negative_index("sigma_cf", "2", 2);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> sigma_cf(2, 2);
            stan::math::initialize(sigma_cf, DUMMY_VAR__);
            stan::math::fill(sigma_cf, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 54;
            stan::math::assign(sigma_cf, quad_form_diag(rho, sigma_record));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 53;
            size_t sigma_cf_j_1_max__ = 2;
            size_t sigma_cf_j_2_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < sigma_cf_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < sigma_cf_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(sigma_cf(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: sigma_cf" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma_cf: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            {
            current_statement_begin__ = 58;
            int rec(0);
            (void) rec;  // dummy to suppress unused var warning
            stan::math::fill(rec, std::numeric_limits<int>::min());
            current_statement_begin__ = 59;
            local_scalar_t__ v0r(DUMMY_VAR__);
            (void) v0r;  // dummy to suppress unused var warning
            stan::math::initialize(v0r, DUMMY_VAR__);
            stan::math::fill(v0r, DUMMY_VAR__);
            current_statement_begin__ = 60;
            local_scalar_t__ kappar(DUMMY_VAR__);
            (void) kappar;  // dummy to suppress unused var warning
            stan::math::initialize(kappar, DUMMY_VAR__);
            stan::math::fill(kappar, DUMMY_VAR__);
            current_statement_begin__ = 61;
            local_scalar_t__ temptr(DUMMY_VAR__);
            (void) temptr;  // dummy to suppress unused var warning
            stan::math::initialize(temptr, DUMMY_VAR__);
            stan::math::fill(temptr, DUMMY_VAR__);
            current_statement_begin__ = 62;
            validate_non_negative_index("mu", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(n);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 66;
            lp_accum__.add(lkj_corr_log<propto__>(rho, lkj));
            current_statement_begin__ = 68;
            lp_accum__.add(normal_log<propto__>(v0_1, 1, 0.3));
            current_statement_begin__ = 69;
            lp_accum__.add(multi_normal_log<propto__>(cf, zeros, sigma_cf));
            current_statement_begin__ = 70;
            lp_accum__.add(normal_log<propto__>(mu_kappa, 0.8, 0.3));
            current_statement_begin__ = 71;
            lp_accum__.add(normal_log<propto__>(mu_tempt, 40, 20));
            current_statement_begin__ = 72;
            lp_accum__.add(cauchy_log<propto__>(get_base1(sigma_record, 1, "sigma_record", 1), 0, 20));
            current_statement_begin__ = 73;
            lp_accum__.add(cauchy_log<propto__>(get_base1(sigma_record, 2, "sigma_record", 1), 0, 0.4));
            current_statement_begin__ = 74;
            lp_accum__.add(cauchy_log<propto__>(sigma, 0., 0.1));
            current_statement_begin__ = 76;
            for (int i = 1; i <= n; ++i) {
                current_statement_begin__ = 77;
                stan::math::assign(rec, get_base1(record, i, "record", 1));
                current_statement_begin__ = 78;
                stan::math::assign(v0r, get_base1(v0_1, rec, "v0_1", 1));
                current_statement_begin__ = 79;
                stan::math::assign(temptr, (mu_tempt + get_base1(get_base1(cf, rec, "cf", 1), 1, "cf", 2)));
                current_statement_begin__ = 80;
                stan::math::assign(kappar, (mu_kappa + get_base1(get_base1(cf, rec, "cf", 1), 2, "cf", 2)));
                current_statement_begin__ = 81;
                stan::model::assign(mu, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((v0r * (1 + ((kappar * get_base1(minute, i, "minute", 1)) / temptr))) * stan::math::exp((-(get_base1(minute, i, "minute", 1)) / temptr))), 
                            "assigning variable mu");
            }
            current_statement_begin__ = 85;
            lp_accum__.add(student_t_log<propto__>(volume_1, student_df, mu, sigma));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("v0_1");
        names__.push_back("sigma_record");
        names__.push_back("mu_kappa");
        names__.push_back("mu_tempt");
        names__.push_back("rho");
        names__.push_back("sigma");
        names__.push_back("cf");
        names__.push_back("sigma_cf");
        names__.push_back("v0");
        names__.push_back("tempt");
        names__.push_back("kappa");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_linexp_gastro_2b_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> v0_1 = in__.vector_lb_constrain(0, n_record);
        size_t v0_1_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < v0_1_j_1_max__; ++j_1__) {
            vars__.push_back(v0_1(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigma_record = in__.vector_lb_constrain(0, 2);
        size_t sigma_record_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < sigma_record_j_1_max__; ++j_1__) {
            vars__.push_back(sigma_record(j_1__));
        }
        double mu_kappa = in__.scalar_lb_constrain(0);
        vars__.push_back(mu_kappa);
        double mu_tempt = in__.scalar_lb_constrain(0);
        vars__.push_back(mu_tempt);
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> rho = in__.corr_matrix_constrain(2);
        size_t rho_j_2_max__ = 2;
        size_t rho_j_1_max__ = 2;
        for (size_t j_2__ = 0; j_2__ < rho_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
                vars__.push_back(rho(j_1__, j_2__));
            }
        }
        double sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma);
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > cf;
        size_t cf_d_0_max__ = n_record;
        cf.reserve(cf_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < cf_d_0_max__; ++d_0__) {
            cf.push_back(in__.vector_constrain(2));
        }
        size_t cf_j_1_max__ = 2;
        size_t cf_k_0_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < cf_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < cf_k_0_max__; ++k_0__) {
                vars__.push_back(cf[k_0__](j_1__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 53;
            validate_non_negative_index("sigma_cf", "2", 2);
            validate_non_negative_index("sigma_cf", "2", 2);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> sigma_cf(2, 2);
            stan::math::initialize(sigma_cf, DUMMY_VAR__);
            stan::math::fill(sigma_cf, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 54;
            stan::math::assign(sigma_cf, quad_form_diag(rho, sigma_record));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t sigma_cf_j_2_max__ = 2;
                size_t sigma_cf_j_1_max__ = 2;
                for (size_t j_2__ = 0; j_2__ < sigma_cf_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < sigma_cf_j_1_max__; ++j_1__) {
                        vars__.push_back(sigma_cf(j_1__, j_2__));
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 89;
            validate_non_negative_index("v0", "n_record", n_record);
            Eigen::Matrix<double, Eigen::Dynamic, 1> v0(n_record);
            stan::math::initialize(v0, DUMMY_VAR__);
            stan::math::fill(v0, DUMMY_VAR__);
            current_statement_begin__ = 90;
            validate_non_negative_index("tempt", "n_record", n_record);
            Eigen::Matrix<double, Eigen::Dynamic, 1> tempt(n_record);
            stan::math::initialize(tempt, DUMMY_VAR__);
            stan::math::fill(tempt, DUMMY_VAR__);
            current_statement_begin__ = 91;
            validate_non_negative_index("kappa", "n_record", n_record);
            Eigen::Matrix<double, Eigen::Dynamic, 1> kappa(n_record);
            stan::math::initialize(kappa, DUMMY_VAR__);
            stan::math::fill(kappa, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 93;
            stan::math::assign(v0, multiply(v0_1, norm_vol));
            current_statement_begin__ = 94;
            for (int i = 1; i <= n_record; ++i) {
                current_statement_begin__ = 95;
                stan::model::assign(tempt, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (mu_tempt + get_base1(get_base1(cf, i, "cf", 1), 1, "cf", 2)), 
                            "assigning variable tempt");
                current_statement_begin__ = 96;
                stan::model::assign(kappa, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (mu_kappa + get_base1(get_base1(cf, i, "cf", 1), 2, "cf", 2)), 
                            "assigning variable kappa");
            }
            // validate, write generated quantities
            current_statement_begin__ = 89;
            size_t v0_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < v0_j_1_max__; ++j_1__) {
                vars__.push_back(v0(j_1__));
            }
            current_statement_begin__ = 90;
            size_t tempt_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < tempt_j_1_max__; ++j_1__) {
                vars__.push_back(tempt(j_1__));
            }
            current_statement_begin__ = 91;
            size_t kappa_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < kappa_j_1_max__; ++j_1__) {
                vars__.push_back(kappa(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    static std::string model_name() {
        return "model_linexp_gastro_2b";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t v0_1_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < v0_1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0_1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_record_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < sigma_record_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_record" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tempt";
        param_names__.push_back(param_name_stream__.str());
        size_t rho_j_2_max__ = 2;
        size_t rho_j_1_max__ = 2;
        for (size_t j_2__ = 0; j_2__ < rho_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rho" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        size_t cf_j_1_max__ = 2;
        size_t cf_k_0_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < cf_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < cf_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t sigma_cf_j_2_max__ = 2;
            size_t sigma_cf_j_1_max__ = 2;
            for (size_t j_2__ = 0; j_2__ < sigma_cf_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < sigma_cf_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sigma_cf" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t v0_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < v0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tempt_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < tempt_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t kappa_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < kappa_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t v0_1_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < v0_1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0_1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_record_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < sigma_record_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma_record" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tempt";
        param_names__.push_back(param_name_stream__.str());
        size_t rho_j_1_max__ = ((2 * (2 - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < rho_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        size_t cf_j_1_max__ = 2;
        size_t cf_k_0_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < cf_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < cf_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t sigma_cf_j_2_max__ = 2;
            size_t sigma_cf_j_1_max__ = 2;
            for (size_t j_2__ = 0; j_2__ < sigma_cf_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < sigma_cf_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sigma_cf" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t v0_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < v0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "v0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tempt_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < tempt_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tempt" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t kappa_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < kappa_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_linexp_gastro_2b_namespace::model_linexp_gastro_2b stan_model;
#endif
