% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMRorig.R
\name{HMR.orig}
\alias{HMR.orig}
\title{HMR fit using the Pedersen fitting algorithm}
\usage{
HMR.orig(t, C, A = 1, V, serie = "", verbose = TRUE, ngrid = 1000,
  plot = FALSE, ...)
}
\arguments{
\item{t}{time values (usually in hours)}

\item{C}{concentration values}

\item{A}{area covered by the chamber}

\item{V}{effective volume of the chamber}

\item{serie}{id of the flux measurement}

\item{verbose}{logical, TRUE prints message after each flux calculation}

\item{ngrid}{see the HMR documentation}

\item{plot}{logical, mainly intended for use in \code{\link{gasfluxes}}}

\item{\dots}{further parameters, currently none}
}
\value{
A list of
   \item{f0}{flux estimate}
   \item{f0.se}{standard error of flux estimate}
   \item{f0.p}{p-value of flux estimate}
   \item{kappa, phi}{other parameters of the HMR model}
   \item{AIC}{Akaike information criterion}
   \item{AICc}{Akaike information criterion with small sample correction}
   \item{diagnostics}{error or warning messages}
}
\description{
Fit the HMR model using the algorithm from the HMR package.
}
\details{
The HMR model (Pedersen et al., 2010) is \eqn{C(t)=\phi+f_0 \frac{e^{-\kappa t}}{-\kappa V/A}}{C(t) = \phi +f0 exp(-\kappa t)/(-\kappa V/A)}.
The algorthm from the HMR package version 0.3.1 is used for fitting. Note that this is very inefficient and standard errors and 
p-values are over-estimated. \code{\link{HMR.fit}} is recommended instead and this function is only provided to be able to reproduce results obtained with
older versions of the HMR package.
}
\examples{
#a single fit
t <- c(0, 1/3, 2/3, 1)
C <- c(320, 341, 352, 359)
print(fit <- HMR.orig(t, C, 1, 0.3, "a"))
plot(C ~ t)
curve({fit$phi + fit$f0 * exp(-fit$kappa * x)/(-fit$kappa*0.3)}, 
      from = 0, to = 1, add = TRUE)

}
\author{
Asger R. Pedersen for code copied from the not-exported HMR:::.HMR.fit1 function,
Roland Fuss
}
\references{
Pedersen, A.R., Petersen, S.O., Schelde, K., 2010. A comprehensive approach to soil-atmosphere trace-gas flux estimation with static chambers. European Journal of Soil Science 61(6), 888-902.
}

