% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{garray}
\alias{garray}
\alias{garray.array}
\alias{as.garray}
\alias{as.garray.garray}
\alias{as.garray.default}
\alias{is.garray}
\alias{is.garray.duck}
\alias{is.scalar}
\title{Generalized and smart array}
\usage{
garray(data, dim = NULL, dimnames = NULL, margins = NULL,
  sdim = attr(data, "sdim", exact = TRUE))

garray.array(x, sdim)

as.garray(x, ...)

\method{as.garray}{garray}(x, ...)

\method{as.garray}{default}(x, ...)

is.garray(x)

is.garray.duck(x)

is.scalar(x)
}
\arguments{
\item{data}{Usually a simple array, and can be a vector without dimensions.}

\item{dim}{An integer vector giving the maximal indices in each dimension.}

\item{dimnames}{A list (or it will be ignored) with for each dimension
one component, either ‘NULL’ or a character vector.}

\item{margins}{Override the names of dim and of dimnames.}

\item{sdim}{Optional, a named list of numeric vectors indicating the
subdivision of some of the dimensions.  The value vill become,
after validated, the attribute sdim.  See 'Details'
and '?sdim'.}

\item{x}{An R object.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\description{
Creates or tests for generalized arrays.
}
\details{
Generalized arrays are generalized because they handle dimensions and
subdimensions that are ragged; and they are also smart
because they automatically match dimensions by margins
(names of dimnames).
Margins is implemented similar to R's native class "table", i.e.,
use names of dimnames to store the margins

Attribute sdim denotes subdimensions, which are the subdivision of
dimensions or grouping of members of a dimension, for organizing a
ragged array.
It is a named list of numeric vectors, each of which indicates the
lengths of subdivision groups within a dimension.  Every name of the
list prefixed with a margin of the generalized array. By the matching
of sdim names and dim names, utility functions figure out which
dimensions the sub dimensions reside in.  Summary of a vector of the
list usually equals to the extent of the corresponding dimension.
If they are not equal and the extent can not be divided exactly
by the summary, the subdimension is invalid and will be dropped.
If the extent can be divided exactly
by the summary, the subdimension is still valid but non-canonical.
Non-canonical subdimension can be provided to \code{garray()} and \code{sdim<-}
as argument, and the two functions can canonicalize it.
Other utility functions cannot handle non-canonical subdimension.
Values of each vector of the list denotes the
repeating times of subdimension residing in the coresponding dimension
(called superdim).
More than 1 subdimension reside in the same superdim is allowed.
This feature allows dividing a subdimension further,
organizing the subdims
into hierachy.

By definition and for S3 dispatching, \code{class(.)="garray"} is required, but
simple arrays with proper margins actually work correctly with most
functionalities of this package.  For the sake of compatibility and
reducing warning message, \code{is.garray.duck()} tests whether the array
has proper margins.

A still problem is that attributes in R are fragile, even indexing
will drop most attributes.  Utility functions and methods for
dispatching for 'garray' implemented in this package guaranttee to
save the margins (names of dimnames) and subdimension (attr(*,'sdim')).
}
\section{Functions}{
\itemize{
\item \code{garray.array}: A simple and faster version of garray(),
mainly for internal usage.  Note that garray() is not generic function,
thus garray.array() will never be called by dispatching.

\item \code{is.garray}: \code{is.garray} do simple validation, no check for validity
of sdim because it is too expensive.
Operation of sdim by this package is always guaranteed the validity.

\item \code{is.garray.duck}: \code{is.garray.duck} do duck-typing validation, ignoring
the class

\item \code{is.scalar}: Test whether the vector or array is actually a scalar
(\code{length(x)==1L}).
}}

\examples{
a1 <- garray(1:27, c(A=3,B=9), sdim=list(A1=c(a=2,b=1),B1=c(a=3)))
a2 <- garray(1:27, c(A=3,B=9), sdim=list(A1=c(a=2,b=1),B1=c(a=4)))
}
