% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pqtl2dplot.R
\name{pqtl2dplot}
\alias{pqtl2dplot}
\title{2D pQTL plot}
\usage{
pqtl2dplot(
  d,
  chrlen = gap::hg19,
  snp_name = "SNP",
  snp_chr = "Chr",
  snp_pos = "bp",
  gene_chr = "p.chr",
  gene_start = "p.start",
  gene_end = "p.end",
  protein = "p.target.short",
  gene = "p.gene",
  lp = "log10p",
  cis = "cis",
  plot = TRUE,
  cex = 0.6
)
}
\arguments{
\item{d}{Data to be used.}

\item{chrlen}{lengths of chromosomes for specific build: hg18, hg19, hg38.}

\item{snp_name}{variant name.}

\item{snp_chr}{variant chromosome.}

\item{snp_pos}{variant position.}

\item{gene_chr}{gene chromosome.}

\item{gene_start}{gene start position.}

\item{gene_end}{gene end position.}

\item{protein}{protein name.}

\item{gene}{gene name.}

\item{lp}{log10(p).}

\item{cis}{cis variant when TRUE.}

\item{plot}{to plot when TRUE.}

\item{cex}{extension factor.}
}
\value{
positional information.
}
\description{
2D pQTL plot
}
\examples{
\dontrun{
INF <- Sys.getenv("INF")
d <- read.csv(file.path(INF,"work","INF1.merge.cis.vs.trans"),as.is=TRUE)
r <- pqtl2dplot(d)
}
}
