% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Query-generics.R, R/Creds-methods.R
\docType{methods}
\name{GaCreds}
\alias{GaCreds}
\alias{GaCreds<-}
\alias{GaCreds,.query,list-method}
\alias{GaCreds,.query,ANY-method}
\alias{GaCreds,character,ANY-method}
\alias{GaCreds,missing,ANY-method}
\alias{GaCreds<-,.query,list-method}
\title{Authentication credentials for Google Analytics API queries.}
\usage{
GaCreds(object = "GANALYTICS", value = NULL, ...)

GaCreds(object) <- value

\S4method{GaCreds}{.query,list}(object, value)

\S4method{GaCreds}{.query,ANY}(object)

\S4method{GaCreds}{character,ANY}(object = "GANALYTICS", value = NULL, ...)

\S4method{GaCreds}{missing,ANY}(object = "GANALYTICS", value = NULL, ...)

\S4method{GaCreds}{.query,list}(object) <- value
}
\arguments{
\item{object}{The object to get the credentials from.}

\item{value}{The replacement credentials for the supplied query object.}

\item{...}{other arguments pass to \code{GoogleApiCreds}.}
}
\description{
Get or set the authentication credentials for a Google Analytics query object.

Set the authentication credentials for a Google Analytics query object.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = .query,value = list}: Return the query with the supplied authentication
credentials supplied.

\item \code{object = .query,value = ANY}: Return the credentials used within the supplied query.

\item \code{object = character,value = ANY}: Create a set of authentication credentials using the
supplied application name.

\item \code{object = missing,value = ANY}: Return default authentication credentials.

\item \code{object = .query,value = list}: Replace the authentication credentials of a query.
}}

