% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmPlotMetricSubspaces.R
\name{dmPlotMetricSubspaceParameters}
\alias{dmPlotMetricSubspaceParameters}
\title{Specify plot parameters for metric subspaces for a level}
\usage{
dmPlotMetricSubspaceParameters(
  level,
  labels = c("*"),
  percent = 10,
  boundary = TRUE,
  color = "red",
  backgroundPercent = 0,
  backgroundColor = "red",
  backgroundReset = TRUE,
  plotLabels = TRUE
)
}
\arguments{
\item{level}{Level for metric subspaces.}

\item{labels}{Vector of labels for metric subspaces.
The default vector contains the wildcard character * which includes all labels.}

\item{percent}{Percent of randomly selected data points of generative data contained in metric subspaces}

\item{boundary}{Boolean value indicating if only data points of metric subspace boundaries should be selected}

\item{color}{Color for data points of generative data contained in metric subspaces}

\item{backgroundPercent}{Percent of randomly selected data points of generative data contained in metric subspaces for background}

\item{backgroundColor}{Color for data points of generative data contained in metric subspaces for background}

\item{backgroundReset}{Before data points for a metric subspace are drawn reset its background.}

\item{plotLabels}{Boolean value indicating if labels for metric subspaces for a level should be displayed}
}
\value{
List of plot parameters for metric subspaces
}
\description{
Specify plot parameters for metric subspaces in a data model for a level.
A list of plot parameters is created for different levels and passed to dmPlotMetricSubspaces().
}
\examples{
\dontrun{
dmPlotMetricSubspaceParameters(0.73)}
}
