% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammaFuncModel.R
\name{generate_f_function}
\alias{generate_f_function}
\title{Function produce predictions from the model}
\usage{
generate_f_function(data, model, grp_var, grp_name = "Diet", ID, ref = 1)
}
\arguments{
\item{data}{Data frame containing columns Group(factor); ID(subject ID: character); Time(positive: numeric); other individiual characteristics covariates (exlcluding other forms of 'Time')}

\item{model}{Fitted model for the metabolite in question}

\item{grp_var}{Value of the grouping variable}

\item{grp_name}{Name of the grouping variable. Default is 'Diet'}

\item{ID}{Subject ID}

\item{ref}{reference group}
}
\value{
f function that produces the prediction from this model for a specific individual in a specific group
}
\description{
Function produce predictions from the model
}
\examples{
\donttest{
require(gammaFuncModel)
require(dplyr)
require(nlme)
modify.df <- data.frame(
  ID = rep(sprintf("\%02d", 1:10), each = 9 * 3),
  Time = rep(rep(1:9, each = 3), 10),
  Diet = as.factor(rep(1:3, times = 9 * 10)),
  Age = rep(sample(20:70, 10, replace = TRUE), each = 9 * 3),
  BMI = round(rep(runif(10, 18.5, 35), each = 9 * 3), 1),
  Concentration = NA
)
for (i in 1:10) {
 for (d in 1:3) {
   C0 <- runif(1, 10, 15)    # initial concentration
   k <- runif(1, 0.1, 0.3)   # decay rate constant
   modify.df$Concentration[modify.df$ID == sprintf("\%02d", i) & modify.df$Diet == d] <- 
     C0 * exp(-k * modify.df$Time[modify.df$ID == sprintf("\%02d", i) & modify.df$Diet == d])
 }
}
covariates <- c("ID", "Diet", "Age", "BMI")
model <- gammaFunction(
  modify.df, 
  covariates, 
  time_grp_inter = FALSE, 
  return_ml_model = FALSE, 
  include_grp = TRUE
 )[[1]]
test_data = modify.df \%>\% 
  filter(Diet == 1 & ID == "04") \%>\% 
  select(-c("Concentration", "ID", "Diet")) 
f_dat = modify.df \%>\% filter(Diet == 1 & ID == "04") \%>\% select(-Concentration)
f <- generate_f_function(
  data = f_dat, 
  model = model,  
  grp_var = 1, 
  grp_name = "Diet", 
  ID = "04", 
  ref = 1
 )
}
}
