% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammaFuncModel.R
\name{gammaFunction}
\alias{gammaFunction}
\title{Implementation of the novel non-linear mixed-effects model based on gamma function form
with nested covariance structure where random effects are specified for each Diet level within each subject (ID), capturing within-subject correlation across dietary conditions.
to identify metabolites that responds to time differentially across dietary groups}
\usage{
gammaFunction(
  data,
  covariates,
  time_terms = c("Time", "log(Time)"),
  grp = "Diet",
  random_formula = ~1 + Time | ID/Diet,
  correlation_formula = corSymm(form = ~Time | ID/Diet),
  weights = varIdent(form = ~1 | Time),
  time_grp_inter = TRUE,
  return_ml_model = FALSE,
  include_grp
)
}
\arguments{
\item{data}{Data frame that contains the 'ID' column along with all covariates as well as concentration column, named 'Concentration', for a single metabolite}

\item{covariates}{Vector containing the names of the "ID" covariate, grouping covariate and other covariates excluding any "Time" covariates}

\item{time_terms}{Vector that contains all additional form of the covariate 'Time" (including the 'Time' covariate), and must contain 'log(Time)', other forms also include I(Time^2) and I(Time^3);}

\item{grp}{Grouping variable;}

\item{random_formula}{Random effects formula for the model, nested effects of Diet within ID (could also add random slope for 'Time');}

\item{correlation_formula}{Correlation formula. Default is autorrgressive but can accomodate other forms such as unstructured covariance or exponential covariance;}

\item{weights}{specify a variance function that models heteroscedasticity}

\item{time_grp_inter}{Boolean value that indicates if the model should include interactions terms of 'time_terms' with 'Group';}

\item{return_ml_model}{Boolean value that indicates if the model should fit "ML" model as well as "REML" model(default)}

\item{include_grp}{boolean value to indicate whether or not 'grp' should be included in the model construction}
}
\value{
mixed effects models for a single metabolites: one with REML, the other with ML
}
\description{
Implementation of the novel non-linear mixed-effects model based on gamma function form
with nested covariance structure where random effects are specified for each Diet level within each subject (ID), capturing within-subject correlation across dietary conditions.
to identify metabolites that responds to time differentially across dietary groups
}
\examples{
require(gammaFuncModel)
require(dplyr)
require(nlme)
df <- data.frame(
  ID = rep(sprintf("\%02d", 1:10), each = 9 * 3),  
  Time = rep(rep(1:9, each = 3), 10),             
  Diet = as.factor(rep(1:3, times = 9 * 10)),    
  Age = rep(sample(20:70, 10, replace = TRUE), each = 9 * 3), 
  BMI = round(rep(runif(10, 18.5, 35), each = 9 * 3), 1),    
  Concentration = round(runif(270, 5, 15), 2)
)
covariates <- c("ID", "Diet", "Age", "BMI")
model <- gammaFunction(
  df, 
  covariates, 
  random_formula = ~ 1  | ID/Diet, 
  correlation_formula = corAR1(form = ~ Time | ID/Diet), 
  weights = NULL,
  include_grp = TRUE)[[1]]
summary(model)

}
\references{
Wickham, H. (2022). dplyr: A Grammar of Data Manipulation. R package version 1.0.10. 
Available at: \url{https://CRAN.R-project.org/package=dplyr}

Pinheiro, J. C., & Bates, D. M. (2022). nlme: Linear and Nonlinear Mixed Effects Models. R package version 3.1-153.
Available at: \url{https://CRAN.R-project.org/package=nlme}
}
