% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{GammaSpectrum-class}
\alias{GammaSpectrum-class}
\alias{.GammaSpectrum}
\title{An S4 Class to Represent a Gamma Sectrum}
\description{
Represents a single spectrum of a gamma ray spectrometry measurement.
}
\section{Slots}{

\describe{
\item{\code{hash}}{A \code{\link{character}} string giving the 32-byte MD5 hash of
the imported file.}

\item{\code{name}}{A \code{\link{character}} string the measurement reference.}

\item{\code{date}}{A \code{\link{POSIXct}} element giving the measurement date and
time.}

\item{\code{instrument}}{A \code{\link{character}} string giving the instrument name.}

\item{\code{file_format}}{A \code{\link{character}} string giving the format of the
imported file.}

\item{\code{live_time}}{A \code{\link{numeric}} value.}

\item{\code{real_time}}{A \code{\link{numeric}} value.}

\item{\code{channel}}{A \code{\link{integer}} vector giving the channel number.
Numeric values are coerced to integer as by \code{\link{as.integer}}
(and hence truncated towards zero).}

\item{\code{energy}}{A \code{\link{numeric}} vector giving the gamma ray's energy
(in keV).}

\item{\code{count}}{A \code{\link{numeric}} vector giving the counts number for
each channel. Numeric values are coerced to integer as by
\code{\link{as.integer}} (and hence truncated towards zero).}

\item{\code{rate}}{A \code{\link{numeric}} vector the count rate (in 1/s) for
each channel.}

\item{\code{calibration}}{A \code{\link[stats:lm]{linear model}} used for energy
scale calibration (see \code{\link{energy_calibrate}}).}
}}

\note{
This class retains copy construction.
}
\section{Access}{

In the code snippets below, \code{x} is a \code{GammaSpectrum} object.
\describe{
 \item{\code{length(x)}}{Get number of channel in \code{x}.}
 \item{\code{get_hash(x)}}{Get the MD5 hash of the raw data file.}
 \item{\code{get_names(x)}, \code{set_names(x) <- value}}{Retrieves or sets
  the name of \code{x} according to \code{value}.}
 \item{\code{get_channels(x)}}{Get the number of channels in \code{x}.}
 \item{\code{get_counts(x)}}{Get the counts of \code{x}.}
 \item{\code{get_energy(x)}}{Get the energy range of \code{x}.}
 \item{\code{get_rates(x)}}{Get the count rates of \code{x}.}
}
}

\section{Coerce}{

In the code snippets below, \code{x} is a \code{GammaSpectrum} object.
\describe{
 \item{\code{as.matrix)}}{Coerces \code{x} to a \code{\link{matrix}}.}
 \item{\code{as.data.frame)}}{Coerces \code{x} to a \code{\link{data.frame}}.}
}
}

\section{Subset}{

In the code snippets below, \code{x} is a \code{GammaSpectrum} object.
\describe{
 \item{\code{x[[i]]}}{Extracts informations from a slot selected by
 subscript \code{i}. \code{i} is a \code{character} vector
 of length one and will be matched to the name of the slots.}
}
}

\examples{
## Import a Canberra CNF file
spc_file <- system.file("extdata/LaBr.CNF", package = "gamma")
(spc <- read(spc_file))

## Access
get_hash(spc)
get_names(spc)
get_livetime(spc)
get_realtime(spc)

length(spc)
range_energy(spc)

## Subset
spc[["date"]]
spc[["instrument"]]
spc[["file_format"]]
}
\seealso{
Other class: 
\code{\link{Baseline-class}},
\code{\link{CalibrationCurve-class}},
\code{\link{GammaSpectra-class}},
\code{\link{PeakPosition-class}},
\code{\link{coerce}()}
}
\author{
N. Frerebeau
}
\concept{class}
