% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam.grptest.R
\name{T.L2c}
\alias{T.L2c}
\title{Test the equality of nonparametric curves or surfaces based on L2 distance}
\usage{
T.L2c(formula, test, data, N.boot = 200, degree = 1, criterion = c("aicc",
  "gcv"), family = c("gaussian", "symmetric"), m = 225, user.span = NULL,
  ...)
}
\arguments{
\item{formula}{A regression formula.  This is like the formula for a lm.}

\item{test}{An indicator of variable for testing nonparametric curves or surface estimations}

\item{data}{A data frame or list containing the model response variable and covariates required by the formula.}

\item{N.boot}{the number of bootstrap replicates. This should be a single positive integer.}

\item{degree}{the degree of the local polynomials to be used. It can ben 0, 1 or 2.}

\item{criterion}{the criterion for automatic smoothing parameter selection: ``aicc'' denotes bias-corrected AIC criterion, ``gcv'' denotes generalized cross-validation.}

\item{family}{if ``gaussian'' fitting is by least-squares, and if ``symmetric'' a re-descending M estimator is used with Tukey's biweight function.}

\item{m}{the number of the sampling points for the Monte-Carlo integration.}

\item{user.span}{the user-defined parameter which controls the degree of smoothing.}

\item{...}{other options from ``loess'' package.}
}
\description{
This function tests the equality of nonparametric curves and surface estimations based on L2 distance.
The specific model considered here is
}
\details{
y_ij= m_i(x_ij) + e_ij,

where m_i(.), are semiparametric smooth functions; e_ij are subject-specific errors. The errors e_ij do not have to be independent N(0, sigma^2) errors. The errors can be heteroscedastic, i.e., e_ij = sigma_i(x_ij) * u_ij, where u_ij are independent identically distributed errors with mean 0 and variance 1.

We are interested in the problem of testing the equality of the regression curves (when x is one-dimensional) or surfaces (when x is two-dimensional),

H_0: m_1(.) = m_2(.) = ... v.s. H_1: otherwise

The problem can also be viewed as the test of the equality in the one-sample problem for functional data.

A bootstrap algorithm is applied to test the equality of semiparametric curves or surfaces based on L2 distance.
}
\examples{
n1 <- 200
x1 <- runif(n1,min=0, max=3)
sd1 <- 0.2
e1 <- rnorm(n1,sd=sd1)
y1 <- sin(2*x1) + cos(2*x1) + e1

n2 <- 120
x2 <- runif(n2, min=0, max=3)
sd2 <- 0.25
e2 <- rnorm(n2, sd=sd2)
y2 <- sin(2*x2) + cos(2*x2) + x2 + e2

dat <- data.frame(rbind(cbind(x1,y1,1), cbind(x2,y2,2)))
colnames(dat)=c('x','y','group')

t1 <- T.L2c(formula=y~x,test=~group,data=dat)
t1$p.value
########
## Semiparametric test the equality for regression surfaces
## Simulate data sets

n1 <- 200
x11 <- runif(n1,min=0, max=3)
x12 <- runif(n1,min=0, max=3)
sd1 <- 0.2
e1 <- rnorm(n1,sd=sd1)
y1 <- 2*x11^2 + 3*x12^2  + e1

n2 <- 120
x21 <- runif(n2, min=0, max=3)
x22 <- runif(n2, min=0, max=3)
sd2 <- 0.25
e2 <- rnorm(n2, sd=sd2)
y2 <- 2*x21^2 + 3*x22^2 + sin(2*pi*x21) + e2

n3 <- 150
x31 <- runif(n3,min=0, max=3)
x32 <- runif(n3,min=0, max=3)
sd3 <- 0.2
e3 <- rnorm(n3,sd=sd1)
y3 <- 2*x31^2 + 3*x32^2  + e3

data.bind <- data.frame(rbind(cbind(x11, x12 ,y1,1), cbind(x21, x22, y2,2), cbind(x31, x32, y3,3)))
colnames(data.bind)=c('x1','x2', 'y','group')

T.L2c(formula=y~x1+x2,test=~group,data=data.bind)
}
\seealso{
\code{\link{gam.grptest}}
}
