######################################
##### PARETO TYPE 1 DISTRIBUTION #####
##### MU IS FIXED HERE ###############
######################################
#-------------------------------------------------------------------------------
# Robert Rigby,  Mikis Stasinopoulos
# this distribution is a one parameter Pareto 
# with mu ifixed and  sigma =alpha-1 free to vary
#################################################################################
#-------------------------------------------------------------------------------
#Probability distribution function
dPARETO1o <- function(x, mu = 1, sigma = 0.5, log = FALSE)
{
   if (any(mu < 0)) stop(paste("mu must be positive", "\n", "")) 
   if (any(sigma <= 0))   stop(paste("sigma must be positive", "\n", ""))  
   if (any(x < mu)) stop(paste("x must be greater than mu", "\n", ""))
   lfy <- log(sigma) + sigma*log(mu) - (sigma+1)*log(x)
   if (log == FALSE) fy <- exp(lfy) else fy <- lfy
   fy
}
#--------------------------------------------------------------------------------
#Cumulative density function
pPARETO1o <- function(q, mu = 1, sigma = 0.5, lower.tail = TRUE, log.p = FALSE)
{
   if (any(mu <= 0)) stop(paste("mu must be positive", "\n", "")) 
   if (any(sigma <= 0)) stop(paste("tau must be positive", "\n", ""))           
   if (any(q < 0)) stop(paste("q must be be greater than 0", "\n", ""))   
   cdf <-  1- (mu/q)^sigma #1 - ((mu/(mu+q))^(sigma)) # mu^sigma*sigma*log(y)
   if (lower.tail == TRUE) cdf <- cdf  
   else cdf <- 1 - cdf
   if (log.p == FALSE) cdf <- cdf
   else cdf < - log(cdf)
   cdf
}   
#-------------------------------
#Quantile-inverse cdf  
qPARETO1o <- function(p, mu = 1, sigma = 0.5, lower.tail = TRUE, log.p = FALSE)
{
  if (any(mu < 0))  stop(paste("mu must be positive", "\n", "")) 
#    if (any(nu < 0))  stop(paste("nu must be positive", "\n", ""))  
    if (any(sigma < 0))  stop(paste("sigma must be positive", "\n", ""))  
    if (log.p==TRUE) p <- exp(p) else p <- p
    if (any(p <= 0)|any(p >= 1))  stop(paste("p must be between 0 and 1", "\n", ""))       
    if (lower.tail==TRUE) p <- p else p <- 1-p
   # w <- qf(p,2,2/sigma)   
   #  q1 <- mu*(((sigma)*w))
    q <-  mu*((1-p)^(-(1/sigma)))   
    q
}
#--------------------------------------------------------------------------------
#Random generation 
rPARETO1o <- function(n, mu = 1, sigma = 0.5)
{
   if (any(mu <= 0)) stop(paste("mu must be positive", "\n", "")) 
   if (any(sigma <= 0)) stop(paste("sigma must be positive", "\n", "")) 
   if (any(n <= 0)) stop(paste("n must be a positive integer", "\n", ""))  
   n <- ceiling(n)
   p <- runif(n)
   r <- qPARETO1o(p, mu = mu, sigma = sigma)
   r 
}
#-------------------------------------------------------------------------------
#Gamlss Family Function
PARETO1o <- function (mu.link = "log", sigma.link = "log") 
{
    mstats <- checklink("mu.link", "Pareto Type 2", substitute(mu.link), 
        c("inverse", "log", "identity", "own"))
    dstats <- checklink("sigma.link", "Pareto Type 2", substitute(sigma.link), 
        c("inverse", "log", "identity", "own"))
    structure(
       list(family = c("PARETO1o", "Pareto 1 mu fixed"), 
        parameters = list(mu = FALSE, sigma = TRUE), 
             nopar = 2, 
              type = "Continuous", 
           mu.link = as.character(substitute(mu.link)), 
        sigma.link = as.character(substitute(sigma.link)), 
        mu.linkfun = mstats$linkfun, 
     sigma.linkfun = dstats$linkfun, 
        mu.linkinv = mstats$linkinv, 
     sigma.linkinv = dstats$linkinv, 
             mu.dr = mstats$mu.eta, 
          sigma.dr = dstats$mu.eta, 
              dldm = function(y, mu, sigma)
              {
               dldm <- ifelse(y >= mu, sigma/mu, 0)
               dldm
                },      
            d2ldm2 = function(y, mu, sigma)
              {
              d2ldm2 <- -sigma/mu^2
              d2ldm2
              },
            dldd = function(y, mu, sigma)  
              {
              dldd <- (1/sigma)+log(mu)-log(y)
              dldd
              },
            d2ldd2 = function(y, mu, sigma)      
              {
              d2ldd2 <- -1/sigma^2
              d2ldd2  
              },
            d2ldmdd = function(y, mu, sigma) #
              {
              d2ldmdd <- 1/mu
              d2ldmdd 
              },
     G.dev.incr = function(y, mu, sigma, ...) -2 * 
            dPARETO1o(y, mu, sigma, log = TRUE), 
          rqres = expression(rqres(pfun = "pPARETO1o", 
           type = "Continuous", y = y, mu = mu, sigma = sigma)), 
     mu.initial = expression({mu <- rep(min(y), length(y))}), 
  sigma.initial = expression({sigma <- rep(.5, length(y))}), 
       mu.valid = function(mu) all(mu > 0), 
    sigma.valid = function(sigma) all(sigma > 0), 
        y.valid = function(y) TRUE,
           mean = function(mu, sigma) ifelse(sigma > 1, mu / (sigma-1), Inf),
       variance = function(mu, sigma) ifelse(sigma > 2, (sigma * mu^2) / ((sigma-1)^2 * (sigma-2)), Inf)), 
          class = c("gamlss.family", "family"))
}
