% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfErr.R
\name{rfErr}
\alias{rfErr}
\title{Calculate Error Rates for randomForest model}
\description{
Given an randomForest model object, calculate training set error,
out-of-bag (OOB) error, and test set error.
}
\usage{
rfErr(train.rf, train, test, group = "type")
}
\arguments{
\item{train.rf}{Fitted randomForest model object.}

\item{train}{Training set data frame.}

\item{test}{Test set data frame.}

\item{group}{Factor that identifies groups}
}
\value{
Vector that holds training set error,
out-of-bag (OOB) error, and test set error rates.
}
\examples{
\dontrun{
data(spam, package='kernlab')
spam[,-58] <- scale(spam[,-58])
nr <- sample(1:nrow(spam))
spam01 <- spam[nr[1:3601],]     ## Use for training,
spam2 <- spam[nr[3602:4601],]   ## Test
spam01.rf <- randomForest(type ~ ., data=spam01)
rfRates <- rfErr(train.rf=spam01.rf, train=spam01, test=spam2,
                 group='type')
}

}
