% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgambin.R, R/gambin_exp.R
\name{dgambin}
\alias{dgambin}
\alias{pgambin}
\alias{rgambin}
\alias{qgambin}
\alias{gambin_exp}
\title{The mixture gambin distribution}
\usage{
dgambin(x, alpha, maxoctave, w = 1, log = FALSE)

pgambin(q, alpha, maxoctave, w = 1, lower.tail = TRUE, log.p = FALSE)

rgambin(n, alpha, maxoctave, w = 1)

qgambin(p, alpha, maxoctave, w = 1, lower.tail = TRUE, log.p = FALSE)

gambin_exp(alpha, maxoctave, w = 1, total_species)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{alpha}{The shape parameter of the GamBin distribution.}

\item{maxoctave}{The scale parameter of the GamBin distribution - which octave is the highest in the empirical dataset?}

\item{w}{A vector of weights. Default, a single weight. This vector must of the same length as alpha.}

\item{log}{logical; If \code{TRUE}, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are P[X <= x], otherwise, P[X > x].}

\item{log.p}{logical; if \code{TRUE}, probabilities p are given as log(p).}

\item{n}{number of random values to return.}

\item{p}{vector of probabilities.}

\item{total_species}{The total number of species in the empirical dataset}
}
\value{
A vector with length MaxOctave + 1 of the expected number of species in each octave
}
\description{
Density, distribution function, quantile function and random generation for the mixture 
gambin distribution.
}
\details{
\code{dgambin} gives the distribution function of a mixture gambin, so all octaves sum to 1.
\code{gambin_exp} multiplies this by the total number of species to give the expected GamBin distribution in units of species, 
for comparison with empirical data.
}
\examples{
## maxoctave is 4. So zero for x = 5
dgambin(0:5, 1, 4)

## Equal weightings between components
dgambin(0:5, alpha = c(1,2), maxoctave = c(4, 4))

## Zero weight on the second component, i.e. a 1 component model
dgambin(0:5, alpha = c(1,2), maxoctave = c(4, 4), w = c(1, 0))
expected = gambin_exp(4, 13, total_species = 200)
plot(expected, type = "l")

##draw random values from a gambin distribution 
x = rgambin(1e6, alpha = 2, maxoctave = 7) 
x = table(x)
freq = as.vector(x)
values = as.numeric(as.character(names(x)))
abundances = data.frame(octave=values, species = freq)
fit_abundances(abundances, no_of_components = 1)


}
\references{
Matthews, T.J. et al. (2017) Extension of the Gambin Distribution to Multimodal Species 
Abundance Distributions. In prep.

Matthews, T.J., Borregaard, M.K., Ugland, K.I., Borges, P.A.V, Rigal, F., Cardoso, P. and Whittaker, R.J. (2014) 
The gambin model provides a superior fit to species abundance distributions with a single free parameter: evidence, 
implementation and interpretation. Ecography 37: 1002-1011.
}
