% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{create_results_analyses}
\alias{create_results_analyses}
\alias{update_results_analyses}
\alias{delete_results_analyses}
\title{Create, Update or Delete Results - Analyses}
\usage{
create_results_analyses(auth, collection_id, name, ...)

update_results_analyses(auth, analysis_id, ...)

delete_results_analyses(auth, analysis_id)
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{collection_id}{The ID number of the collection}

\item{name}{The name of the Results object to create}

\item{...}{List(s) to add additional data}

\item{analysis_id}{The ID number of the analyses}
}
\value{
If creating or updating, a data frame with the new details.
When deleting, JSON response indicating success or failure.
}
\description{
Create, Update or Delete Results - Analyses
}
\details{
Each endpoint has a list of required elements, as listed in the
parameters.

For optional data, such as attributes, you may pass additional lists. The
top level name of this optional list should match the name of the json
level to be added, with key-value pairs within the list. Ultimately, this
list object will be added as a child json level, under the 'data' top level
json.

For example: \code{attributes} is a json is nested under data, and therefore
should be created as the name of the object. Then additional information
can be added to it as a key-value pair to the list.
}
\section{Functions}{
\itemize{
\item \code{update_results_analyses}: Update an analyses

\item \code{delete_results_analyses}: Delete an analyses
}}

