% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov.galamm}
\alias{vcov.galamm}
\title{Calculate variance-covariance matrix for GALAMM fit}
\usage{
\method{vcov}{galamm}(object, parm = "beta", ...)
}
\arguments{
\item{object}{Object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{parm}{The parameters for which the variance-covariance matrix should be
calculated. Character vector with one or more of the elements "theta",
"beta", "lambda", and "weights". Can also be an integer vector. When given
as a character, it must be in only lowercase letters.}

\item{...}{Further arguments passed on to other methods. Currently not used.}
}
\value{
A variance-covariance matrix.
}
\description{
Calculate variance-covariance matrix for GALAMM fit
}
\examples{
# Linear mixed model with heteroscedastic residuals
mod <- galamm(
  formula = y ~ x + (1 | id),
  weights = ~ (1 | item),
  data = hsced
)

# Extract covariance matrix for fixed regression coefficients
vcov(mod, parm = "beta")

# and then for weights, which gives us the variance.
vcov(mod, parm = "weights")

}
\seealso{
\code{\link[=confint.galamm]{confint.galamm()}} for the method computing confidence intervals.
See \code{\link[=vcov]{vcov()}} for the generic function.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()}
}
\concept{details of model fit}
