% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.R
\name{ranef.galamm}
\alias{ranef.galamm}
\alias{ranef}
\title{Extract random effects from galamm object.}
\usage{
\method{ranef}{galamm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{galamm}, returned from
\code{\link{galamm}}.}

\item{...}{Optional parameters passed on to other methods. Currently not
used.}
}
\value{
An object of class \code{ranef.galamm}, containing the requested
random effects.
}
\description{
Extract random effects from galamm object.
}
\examples{
# Poisson GLMM
count_mod <- galamm(
  formula = y ~ lbas * treat + lage + v4 + (1 | subj),
  data = epilep, family = poisson
)

# Extract random effects
ranef(count_mod)

}
\references{
\insertRef{batesFittingLinearMixedEffects2015}{galamm}
}
\seealso{
\code{\link[=fixef.galamm]{fixef.galamm()}} for fixed effects and \code{\link[=coef.galamm]{coef.galamm()}} for
coefficients more generally.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\author{
This function is derived from \code{lme4::ranef.merMod}, written by
Douglas Bates, Martin Maechler, Ben Bolker, Steve Walker.
}
\concept{details of model fit}
