% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_all_reasons.R
\name{show_all_reasons}
\alias{show_all_reasons}
\title{List valid download reasons}
\usage{
show_all_reasons()
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble) of
valid download reasons, containing the id and name for each reason.
}
\description{
When downloading occurrence data with \code{\link[=atlas_occurrences]{atlas_occurrences()}} the
ALA APIs require a reason for download to be specified. By default, a
download reason of 'scientific research' is set for you, but if you wish to
change this you can do so with \code{\link[=galah_config]{galah_config()}}. Use this function
to view the list of download reason code and names. When specifying a reason,
you can use either the download code or name.
}
\section{Examples}{


Show a listing of all accepted reasons for downloading occurrence data\if{html}{\out{<div class="sourceCode r">}}\preformatted{show_all_reasons()
#> # A tibble: 13 x 2
#>       id name                            
#>    <int> <chr>                           
#>  1     0 conservation management/planning
#>  2     1 biosecurity management/planning 
#>  3     2 environmental assessment        
#>  4     3 education                       
#>  5     4 scientific research             
#>  6     5 collection management           
#>  7     6 other                           
#>  8     7 ecological research             
#>  9     8 systematic research/taxonomy    
#> 10    10 testing                         
#> 11    11 citizen science                 
#> 12    12 restoration/remediation         
#> 13    13 species modelling
}\if{html}{\out{</div>}}

Add your download reason when configuring your session with \code{\link[=galah_config]{galah_config()}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_config(download_reason_id = 3)
}\if{html}{\out{</div>}}
}

\seealso{
This function is helpful in setting up \code{\link[=galah_config]{galah_config()}}.
}
