% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_profile_attributes.R
\name{search_profile_attributes}
\alias{search_profile_attributes}
\title{Search for which quality filters are applied by a data quality profile}
\usage{
search_profile_attributes(profile)
}
\arguments{
\item{profile}{\code{string}: a data quality profile name, short name or id.
See \code{\link[=show_all_profiles]{show_all_profiles()}} for valid filters}
}
\value{
A \code{data.frame} of profile attributes, consisting of a
free text \code{description} and the actual \code{filter} used.
}
\description{
Each data quality profile is made up of a series of filters. While some users
may wish to simply trust the default filters, it is often useful to check
what information they return, particularly if advanced customization is needed.
This function gives all of the arguments built into a specific profile.
}
\section{Examples}{


To find all the data quality arguments used in the profile "CSDM"\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_profile_attributes("CSDM")
#> # A tibble: 4 x 2
#>   description                                                               filter                       
#>   <chr>                                                                     <chr>                        
#> 1 "Include only records where Spatial validity is \\"true\\""                 "spatiallyValid:\\"true\\""    
#> 2 "Exclude potential duplicate records"                                     "-isDuplicateOf:*"           
#> 3 "Exclude all records that are an outlier against any environmental layer" "-outlierLayerCount:[1 TO *]"
#> 4 "Include only records where Year is 1970 to 2099"                         "year:[1970 TO *]"
}\if{html}{\out{</div>}}

Then get a free-text description of each filter used in the "CSDM" profile\if{html}{\out{<div class="sourceCode r">}}\preformatted{profile_info <- search_profile_attributes("CSDM")
profile_info$description
#> [1] "Include only records where Spatial validity is \\"true\\""                
#> [2] "Exclude potential duplicate records"                                    
#> [3] "Exclude all records that are an outlier against any environmental layer"
#> [4] "Include only records where Year is 1970 to 2099"
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=show_all_profiles]{show_all_profiles()}} for a list of valid profiles;
\code{\link[=galah_filter]{galah_filter()}} for how to include this information in a data
query.
}
