% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetics-maneuvers.R
\name{genetic_posteriors2rasters}
\alias{genetic_posteriors2rasters}
\title{Convert posteriors to particular genetic reporting groups into raster}
\usage{
genetic_posteriors2rasters(G, R)
}
\arguments{
\item{G}{long format data frame like breeding_wiwa_genetic_posteriors.  Has to have columns of ID, region, and posterior}

\item{R}{a RasterStack like "genetic_regions".  The sum of these should be the total known range.
The names of the regions in R must be the same as the entries in the "region" column in G.}
}
\value{
This returns a list of rasters for each bird in G.  The entries in the raster
are the posterior probability of being from that cell.  This assumes that birds are equally likely
to come from any cell within the group's region.  It doesn't return a rasterStack because you
can't subset rasterStacks to change orders, etc., and it mangles names.
}
\description{
When birds have been assigned to breeding groups or "general areas" as in Ruegg et al. 2014
then the posterior probabilty with which the birds were assigned to the groups needs to be
"smeared out" in a raster over the spatial extent of the groups.
}
\examples{
library(raster)  # needed to deal with "genetic_regions" variable
# get a small subset of individuals so it doesn't take too long
data(breeding_wiwa_genetic_posteriors)
data(genetic_regions)
BW <- breeding_wiwa_genetic_posteriors \%>\%
  dplyr::filter(Short_Name \%in\% c("eNBFR01", "wABCA05", "wORHA21"))

# run the function on those
GPRs <-  genetic_posteriors2rasters(BW, genetic_regions)
}

