## use gformlayout from gWidgets -- which was inspired by extjs fieldset
## changes should synchronize with gWidgets file

## helper functions
.makeForm <- function(lst, parent, e,  ...) {
  g <- ggroup(cont = parent, expand=TRUE,...)

  ## make a local copy of lst and modify for do.call
  tmp <- lst;
  tmp$name <- tmp$type <- tmp$children <- NULL
  tmp$depends.on <- tmp$depends.FUN <- tmp$depends.signal <- NULL
  tmp$container <- g; tmp$expand <- TRUE
  ## expand functions
  for(i in names(tmp)) {
    if(is.function(tmp[[i]]))
      tmp[[i]] <- tmp[[i]]()
  }
  
  ## treat fieldset differently
  if(lst$type == "fieldset") {
    .makeFieldset(lst, g, e, label = lst$label, width=lst$width, height=lst$height)
    return()
  } else {  
    ## make object
    newObject <- do.call(lst$type, tmp)
    ## store if a name is given
    if(!is.null(lst$name))
      e[[lst$name]] <- newObject
    ## do we enable new object
    if(!is.null(lst$depends.on)) {
      widget <- e[[lst$depends.on]]
      if(is.null(lst$depends.signal))
        lst$depends.signal <- "addHandlerChanged"
      do.call(lst$depends.signal,list(obj=widget,handler =  function(h,...) {
        value <- svalue(h$obj)
        enabled(newObject) <- lst$depends.FUN(value)
      }))
      enabled(newObject) <- lst$depends.FUN(svalue(widget))
    }
  }
   


  
  ## show children if there
  ## this recurses except on "fieldset"
  if(!is.null(lst$children)) {
    for(i  in 1:length(lst$children)) {
      l <- lst$children[[i]]
      if(l$type == "fieldset") {
        if(lst$type == "gnotebook")
          .makeFieldset(l, newObject, e, label = l$label)
        else
          .makeFieldset(l, newObject, e, width = l$width, height = l$height)
      } else {
        if(lst$type == "gnotebook")
          .makeForm(l, newObject, e, label = l$label)
        else
          .makeForm(l, newObject, e)
      }
    }
  }
}


## fieldset does not recurse
.makeFieldset <- function(lst, parent, e, width=NULL, height=NULL, ...) {
  ## parent is parent container
  ## lst is list as above

  
  ## outer container
  if(!is.null(lst$label)) 
    g <- gframe(lst$label, cont = parent, width=width, height=height,...)
  else
    g <- ggroup(cont = parent,  width=width, height = height, ...)
  ## main table
  tbl <- glayout(cont = g)
  
  ## do we enable new object
  if(!is.null(lst$depends.on)) {
    widget <- e[[lst$depends.on]]
    if(is.null(lst$depends.signal))
      lst$depends.signal <- "addHandlerChanged"
    do.call(lst$depends.signal, list(obj = widget,handler = function(h,...) {
      value <- svalue(h$obj)
      enabled(g) <- lst$depends.FUN(value)
    }))
    enabled(g) <- lst$depends.FUN(svalue(widget))
  }
  
  ## fix label adjust
  if(is.null(lst$label.pos))
    lst$label.pos <- "left"
  if(lst$label.pos == "top") {
    label.anchor <- c(-1,0)
  } else {
    if(is.null(lst$label.just) || lst$label.just == "left")
      label.anchor <- c(-1,1)
    else if(lst$label.just == "center")
      label.anchor <- c(0,1)
    else
      label.anchor <- c(1,1)
  }
  
  if(is.null(lst$columns)) 
    no.columns <- 1
  else
    no.columns <- lst$columns
  
  ## add children
  for(i in 1:length(lst$children)) {
    l <- lst$children[[i]]
    ## each child is a list with name, label, type, then arguments
    ## make new list for do.call
    tmp <- l;
    tmp$name <- tmp$label <- tmp$type <- NULL
    tmp$depends.on <- tmp$depends.FUN <- tmp$depends.signal <- NULL
    tmp$container <- tbl

    newWidget <- do.call(l$type, tmp)

    ## store
    if(!is.null(l$name))
      e[[l$name]] <- newWidget
    ## do we enable new object
    if(!is.null(l$depends.on)) {
      widget <- e[[l$depends.on]]
      if(is.null(l$depends.signal))
        l$depends.signal <- "addHandlerChanged"
      do.call(l$depends.signal, list(obj = widget, handler =  function(h,...) {
        value <- svalue(h$obj)
        enabled(newWidget) <- l$depends.FUN(value)
      }))
      enabled(newWidget) <- l$depends.FUN(svalue(widget))
    }

    
    ## add to table
    col <- 1 + (i - 1) %% no.columns    #1, ..., no.columns
    row <- 1 + (i - 1) %/% no.columns   #1, ...
    newLabel <- glabel(l$label, cont = tbl)
    if(!is.null(lst$label.font))
      font(newLabel) <- lst$label.font
    if(is.null(lst$label.pos) || lst$label.pos == "left") {
      tbl[row, 2 * (col - 1) + 1, anchor=label.anchor] <- newLabel
      if(l$type %in% c("gcombobox","gdroplist"))
        tbl[row, 2 * (col - 1) + 2, anchor=c(-1,1), expand=TRUE] <- newWidget
      else
        tbl[row, 2 * (col - 1) + 2, anchor=c(-1,1)] <- newWidget
    } else {
      tbl[2 * (row - 1) + 1, col, anchor=label.anchor] <- newLabel
      if(l$type %in% c("gcombobox","gdroplist"))
        tbl[2 * (row - 1) + 2, col, anchor=c(-1,1), expand=TRUE] <- newWidget
      else
        tbl[2 * (row - 1) + 2, col, anchor=c(-1,1)] <- newWidget
    }
  }
}



gformlayout <- function(lst, container = NULL, ...) {
  obj <- ggroup(cont = container, ...)


  e <- new.env()
  .makeForm(lst, obj, e)

  class(obj) <- c("gFormLayout",class(obj))
  obj$widgets <- lapply(e, function(i) i)

  obj$getValue <- function(., index=NULL, drop=NULL)
    return(lapply(.$widgets, svalue))
  obj$getNames <- function(.)
    return(names(.$widgets))
  
  
  return(obj)
}
