% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-coerce-list.R
\name{graph-coerce-list}
\alias{graph-coerce-list}
\alias{g_ugl2gn_}
\alias{g_ugl2ig_}
\alias{g_ugl2dm_}
\alias{g_ugl2sm_}
\alias{g_ugl2XX_}
\alias{g_dagl2gn_}
\alias{g_dagl2ig_}
\alias{g_dagl2dm_}
\alias{g_dagl2sm_}
\alias{g_dagl2XX_}
\alias{g_adl2gn_}
\alias{g_adl2ig_}
\alias{g_adl2dm_}
\alias{g_adl2sm_}
\alias{g_adl2XX_}
\alias{g_M2adl_}
\alias{g_M2ugl_}
\alias{g_M2dagl_}
\alias{g_ugl2M_}
\alias{g_dagl2M_}
\alias{g_adl2M_}
\title{Coercion of graphs represented as lists}
\usage{
g_ugl2gn_(glist, vn = NULL)

g_ugl2ig_(zz, vn = NULL)

g_ugl2dm_(zz, vn = NULL)

g_ugl2sm_(zz, vn = NULL)

g_ugl2XX_(zz, outtype, vn = NULL)

g_dagl2gn_(glist, vn = NULL)

g_dagl2ig_(zz, vn = NULL)

g_dagl2dm_(zz, vn = NULL)

g_dagl2sm_(zz, vn = NULL)

g_dagl2XX_(zz, outtype, vn = NULL)

g_adl2gn_(zz)

g_adl2ig_(zz)

g_adl2dm_(zz)

g_adl2sm_(zz)

g_adl2XX_(zz, outtype)

g_M2adl_(amat)

g_M2ugl_(amat)

g_M2dagl_(amat)

g_ugl2M_(glist, vn = NULL, result = "matrix")

g_dagl2M_(glist, vn = NULL, result = "matrix")

g_adl2M_(alist, result = "matrix")
}
\arguments{
\item{glist}{A list of generators where a generator is a character
vector. If interpreted as generators of an undirected graph, a
generator is a complete set of vertices in the graph. If
interpreted as generators of a dag, a generator (v1,...,vn)
means that there will be arrows from v2,...,vn to v1.}

\item{vn}{The names of the vertices in the graphs. These will be
the row and column names of the matrix.}

\item{zz}{An object representing a graph.}

\item{outtype}{What should a list be coerced to.}

\item{amat}{Adjacency matrix (dense or sparse dgCMatrix).}

\item{result}{A graph object.}

\item{alist}{An adjacency list.}
}
\description{
Coercion of graphs represented as lists to various
graph formats.
}
\examples{

## Sparse and dense adjacency matrices converted to adjacency list 
g1 <- ug(~a:b + b:c + c:d, result="matrix")
g2 <- ug(~a:b + b:c + c:d, result="dgCMatrix")
g_M2adl_( g1 )

## Sparse and dense adjacency matrices converted to cliques
g_M2ugl_( g1 )

## Sparse and dense adjacency matrices converted to cliques
g_M2dagl_( g1 )

## g_M2adl_( g2 ) ## FIXME FAILS for sparse matrix
## g_M2ugl_( g2 ) ## FIXME Is there an issue here??
## g_M2dagList( g2 ) ## Fails for sparse matrix

}
