% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grbase-utilities.R
\name{gRbase_utilities}
\alias{gRbase_utilities}
\alias{rhsFormula2list}
\alias{matrix2list}
\alias{rowmat2list}
\alias{colmat2list}
\alias{rhsf2list}
\alias{list2rhsFormula}
\alias{list2rhsf}
\alias{which.arr.index}
\alias{which_matrix_index}
\alias{rowSumsPrim}
\alias{colSumsPrim}
\alias{colwiseProd}
\title{gRbase utilities}
\usage{
rhsFormula2list(form)

rhsf2list(form)

list2rhsFormula(form)

list2rhsf(form)

rowmat2list(X)

colmat2list(X)

matrix2list(X, byrow = TRUE)

which.arr.index(X)

which_matrix_index(X)

rowSumsPrim(X)

colSumsPrim(X)

colwiseProd(v, X)
}
\arguments{
\item{form}{Formula specification (a right-hand sided formula, a
numeric/character vector or a list of vectors).}

\item{X}{A matrix.}

\item{byrow}{Should the split be by row or by column.}

\item{v}{A vector.}
}
\description{
Various utility functions for gRbase. Includes 'faster
    versions' of certain standard R functions.
}
\details{
\code{which.arr.ind}: Returns matrix n x 2 matrix with
    indices of non-zero entries in matrix \code{X}. Notice
    \code{which_matrix_index__} is cpp implementation.

\code{colwiseProd}: multiplies a vector v and a matrix X
    columnwise (as opposed to rowwise which is achieved by
    \code{v * X}). Hence \code{colwiseProd} does the same as
    \code{t(v * t(X))} - but it does so faster for numeric values.
}
\examples{
## colwiseProd
X <- matrix(1:16, nrow=4)
v <- 1:4
t(v * t(X))
colwiseProd(v, X)
\dontrun{
system.time(for (ii in 1:100000)  t(v * t(X)))
system.time(for (ii in 1:100000)  colwiseProd(v, X))
}

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
