% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-utilities.R
\name{graph-cliques}
\alias{graph-cliques}
\alias{get_cliques}
\alias{get_cliques.graphNEL}
\alias{get_cliques.default}
\alias{max_cliqueMAT}
\title{Get cliques of an undirected graph}
\usage{
get_cliques(object)

\method{get_cliques}{graphNEL}(object)

\method{get_cliques}{default}(object)

max_cliqueMAT(amat)
}
\arguments{
\item{object}{An undirected graph represented either as a \code{graphNEL}
object, a (dense) \code{matrix}, a (sparse) \code{dgCMatrix}}

\item{amat}{An adjacency matrix.}
}
\value{
A list.
}
\description{
Return a list of (maximal) cliques of an undirected graph.
}
\details{
In graph theory, a clique is often a complete subset of a graph. A maximal
clique is a clique which can not be enlarged. In statistics (and that is the
convention we follow here) a clique is usually understood to be a maximal
clique.

Finding the cliques of a general graph is an NP complete problem. Finding
the cliques of triangualted graph is linear in the number of cliques.

The workhorse is the \code{max_cliqueMAT} function which calls the
\code{maxClique} function in the \code{RBGL} package.
}
\examples{

## graphNEL
uG1 <- ug(~a:b + b:c + c:d + d:e + e:f + f:a)
get_cliques(uG1)

## adjacency matrix
uG2 <- ug(~a:b + b:c + c:d + d:e + e:f + f:a, result="matrix")
get_cliques(uG2)

## adjacency matrix (sparse)
uG3 <- ug(~a:b + b:c + c:d + d:e + e:f + f:a, result="dgCMatrix")
get_cliques(uG3)


}
\seealso{
\code{\link{ug}}, \code{\link{dag}}, \code{\link{mcs}},
    \code{\link{mcsMAT}}, \code{\link{rip}}, \code{\link{ripMAT}},
    \code{\link{moralize}}, \code{\link{moralizeMAT}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
