% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{integerPoints}
\alias{integerPoints}
\title{Integer points in the feasible region (Ax<=b).}
\usage{
integerPoints(A, b, nonneg = rep(TRUE, ncol(A)))
}
\arguments{
\item{A}{Constraint matrix.}

\item{b}{Right hand side.}

\item{nonneg}{A boolean vector of same length as number of variables. If
entry k is TRUE then variable k must be non-negative.}
}
\value{
A data frame with all integer points inside the feasible region.
}
\description{
Integer points in the feasible region (Ax<=b).
}
\note{
Do a simple enumeration of all integer points between min and max values found using the continuous polytope.
}
\examples{
A <- matrix( c(3,-2, 1, 2, 4,-2,-3, 2, 1), nc = 3, byrow = TRUE)
b <- c(10, 12, 3)
integerPoints(A, b)

A <- matrix(c(9, 10, 2, 4, -3, 2), ncol = 2, byrow = TRUE)
b <- c(90, 27, 3)
integerPoints(A, b)
}
\author{
Lars Relund \email{lars@relund.dk}.
}
