/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.af.commons.widgets.validate.RealTextField;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.PDialog;
import org.af.gMCP.gui.power.UserDefinedDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PowerReq
implements ActionListener {
    List<JCheckBox> includeL = new Vector<JCheckBox>();
    JTextField scname;
    JTextField targetPower;
    String[] selection = new String[]{"All of the selected", "Any of the selected", "User defined"};
    JComboBox<String> jcbType = new JComboBox<String>(this.selection);
    String userDefined;
    PDialog pd;

    public PowerReq(PDialog pd, String name) {
        this.pd = pd;
        this.scname = new JTextField(name);
        this.targetPower = new RealTextField("targetPower", 10, 0.0, 1.0);
        this.targetPower.setText("0.8");
        for (Node n : pd.getNodes()) {
            JCheckBox jc = new JCheckBox();
            this.includeL.add(jc);
        }
        this.jcbType.setPreferredSize(new Dimension(this.jcbType.getPreferredSize().width, this.includeL.get((int)0).getPreferredSize().height));
    }

    public void setActionListener() {
        this.jcbType.addActionListener(this);
    }

    public void addComponents(JPanel panel, CellConstraints cc, int row) {
        int col = 2;
        panel.add((Component)this.scname, cc.xy(col, row));
        panel.add(this.jcbType, cc.xy(col += 2, row));
        panel.add((Component)this.targetPower, cc.xy(col += 2, row));
        for (JCheckBox jc : this.includeL) {
            panel.add((Component)jc, cc.xy(col += 2, row));
        }
        row += 2;
    }

    public String getNCPString() {
        String s = RControl.getR().eval("make.names(\"" + this.scname.getText() + "\")").asRChar().getData()[0] + "=c(";
        for (JCheckBox jc : this.includeL) {
            s = s + jc.getText() + ", ";
        }
        return s.substring(0, s.length() - 2) + ")";
    }

    public String getPowerfunction() {
        String term = "";
        if (this.jcbType.getSelectedIndex() == 0) {
            term = "all(x";
        } else if (this.jcbType.getSelectedIndex() == 1) {
            term = "any(x";
        } else {
            return "'" + this.jcbType.getItemAt(2) + "'=function(x) {" + this.jcbType.getItemAt(2) + "}";
        }
        String subset = "[c(";
        boolean all = true;
        for (int i = 0; i < this.includeL.size(); ++i) {
            if (this.includeL.get(i).isSelected()) {
                subset = subset + "" + i + ",";
                continue;
            }
            all = false;
        }
        subset = subset.length() > 3 ? subset.substring(0, subset.length() - 1) + ")]" : "[NULL]";
        if (all) {
            subset = "";
        }
        term = term + subset;
        return "'" + term + "'=function(x) {" + term + ")}";
    }

    public void loadConfig(Element e) {
        this.scname.setText(e.getAttribute("name"));
        this.targetPower.setText(e.getAttribute("tpower"));
        this.jcbType.setSelectedIndex(Integer.parseInt(e.getAttribute("index")));
        if (this.jcbType.getSelectedIndex() >= 2) {
            for (JCheckBox jc : this.includeL) {
                jc.setEnabled(false);
            }
            this.userDefined = e.getAttribute("userDefined");
            this.jcbType.removeItemAt(2);
            this.jcbType.addItem(this.userDefined);
            this.jcbType.addItem("Edit user defined");
            this.jcbType.setSelectedIndex(2);
        }
        NodeList nlist = e.getChildNodes();
        for (int i = 0; i < Math.min(nlist.getLength(), this.includeL.size()); ++i) {
            this.includeL.get(i).setSelected(Boolean.parseBoolean(((Element)nlist.item(i)).getAttribute("include")));
        }
    }

    public Element getConfigNode(Document document) {
        Element e = document.createElement("powerreq");
        e.setAttribute("name", this.scname.getText());
        e.setAttribute("tpower", this.targetPower.getText());
        e.setAttribute("index", "" + this.jcbType.getSelectedIndex());
        e.setAttribute("userDefined", this.userDefined);
        for (JCheckBox jc : this.includeL) {
            Element eNCP = document.createElement("include");
            eNCP.setAttribute("include", "" + jc.isSelected());
            e.appendChild(eNCP);
        }
        return e;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jcbType && (this.jcbType.getSelectedItem().equals(this.selection[2]) || this.jcbType.getSelectedItem().equals("Edit user defined"))) {
            UserDefinedDialog udd = new UserDefinedDialog(this.pd);
            this.userDefined = udd.getUserDefined();
            if (this.jcbType.getItemCount() == 3) {
                this.jcbType.removeItemAt(2);
                this.jcbType.addItem(this.userDefined);
                this.jcbType.addItem("Edit user defined");
            } else {
                this.jcbType.removeItemAt(2);
                this.jcbType.removeItemAt(2);
                this.jcbType.addItem(this.userDefined);
                this.jcbType.addItem("Edit user defined");
            }
            this.jcbType.setSelectedIndex(2);
            for (JCheckBox jc : this.includeL) {
                jc.setSelected(true);
            }
        }
        if (this.jcbType.getSelectedIndex() < 2) {
            for (JCheckBox jc : this.includeL) {
                jc.setEnabled(true);
            }
        } else {
            for (JCheckBox jc : this.includeL) {
                jc.setEnabled(false);
            }
        }
    }
}

