/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeWeight {
    private static final Log logger = LogFactory.getLog(EdgeWeight.class);
    private String weightStr = null;
    protected double[] weight = null;
    static DecimalFormat formatSmall = new DecimalFormat("#.###E0");
    public static final String[] greekLaTeX = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "pi", "rho", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega"};
    public static final char[] greek = new char[]{'\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03c0', '\u03c1', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9'};
    public static final String NO_GREEK_CHARACTER = "No greek character";
    private Boolean isEpsilon = null;
    public static Hashtable<String, Boolean> isEpsTable = new Hashtable();

    public EdgeWeight(String weightStr) {
        if (weightStr == null) {
            weightStr = "NULL";
        }
        this.weightStr = weightStr;
    }

    public EdgeWeight(double weight) {
        this.weight = new double[]{weight};
        this.setWeightStr(weight);
    }

    public String getPreciseWeightStr() {
        if (this.weight != null) {
            return "" + this.weight[0];
        }
        return this.toString();
    }

    private void setWeightStr(double weight) {
        DecimalFormat format = Configuration.getInstance().getGeneralConfig().getDecFormat();
        this.weightStr = !Configuration.getInstance().getGeneralConfig().showFractions() ? (weight != 0.0 && Math.abs(weight) < Math.pow(0.1, Configuration.getInstance().getGeneralConfig().getDigits()) ? formatSmall.format(weight) : format.format(weight)) : (weight != 0.0 && Math.abs(weight) < Math.pow(0.1, 3.0) ? formatSmall.format(weight) : RControl.getFraction((Double)weight, true));
        this.isEpsilon = null;
    }

    public String toString() {
        return this.weightStr;
    }

    public double getWeight(Hashtable<String, Double> ht) {
        try {
            String s;
            String replaceStr = this.weightStr;
            if (this.weight != null) {
                return this.weight[0];
            }
            Enumeration<String> keys = ht.keys();
            while (keys.hasMoreElements()) {
                s = keys.nextElement();
                for (int i = 0; i < greek.length; ++i) {
                    if (!("" + greek[i]).equals(s)) continue;
                    replaceStr = replaceStr.replaceAll("" + greekLaTeX[i], "" + ht.get(s));
                }
            }
            keys = ht.keys();
            while (keys.hasMoreElements()) {
                s = keys.nextElement();
                replaceStr = replaceStr.replaceAll(s, "" + ht.get(s));
            }
            this.weight = RControl.getR().eval(replaceStr).asRNumeric().getData();
            return this.weight[0];
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static String UTF2LaTeX(char greekC) {
        for (int i = 0; i < greek.length; ++i) {
            if (greekC != greek[i]) continue;
            return greekLaTeX[i];
        }
        return "" + greekC;
    }

    public List<String> getVariables() {
        int i;
        String replaceStr = this.weightStr;
        Vector<String> variables = new Vector<String>();
        for (i = 0; i < greek.length; ++i) {
            if ((replaceStr = replaceStr.replaceAll(greekLaTeX[i], "" + greek[i])).lastIndexOf(greek[i]) == -1) continue;
            variables.add("" + greek[i]);
        }
        for (i = 0; i < 26; ++i) {
            char l = (char)(97 + i);
            if (replaceStr.lastIndexOf(l) == -1) continue;
            variables.add("" + l);
        }
        return variables;
    }

    public String getLaTeXStr() {
        if (this.weight != null && this.weight.length == 1) {
            if (this.weight[0] != 0.0 && this.weight[0] < Math.pow(0.1, 3.1)) {
                String weightStr = formatSmall.format(this.weight[0]);
                if (weightStr.indexOf("E-") != -1) {
                    weightStr = weightStr.replaceAll("E-", "}{10^{");
                    weightStr = "\\frac{" + weightStr + "}}";
                }
                return weightStr;
            }
            return RControl.getR().eval("gMCP:::getLaTeXFraction(" + this.weight[0] + ")").asRChar().getData()[0];
        }
        String replaceStr = this.weightStr;
        for (int i = 0; i < greek.length; ++i) {
            replaceStr = replaceStr.replaceAll("" + greek[i], greekLaTeX[i]);
        }
        return replaceStr;
    }

    public boolean isEpsilon() {
        String s = this.getPreciseWeightStr();
        try {
            if (this.isEpsilon == null) {
                this.isEpsilon = isEpsTable.get(s);
                if (this.isEpsilon == null) {
                    this.isEpsilon = RControl.getR().eval("gMCP:::isEpsilon(\"" + s.replaceAll("\\\\", "\\\\\\\\") + "\")").asRLogical().getData()[0];
                    isEpsTable.put(s, this.isEpsilon);
                }
            }
            return this.isEpsilon;
        }
        catch (Exception e) {
            return false;
        }
    }
}

