% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subVariables.R
\name{substituteEps}
\alias{substituteEps}
\title{Substitute Epsilon}
\usage{
substituteEps(graph, eps = 10^(-3))
}
\arguments{
\item{graph}{A graph of class \code{\link{graphMCP}} or class
\code{\link{entangledMCP}}.}

\item{eps}{A numeric scalar specifying a value for epsilon edges.}
}
\value{
A graph where all epsilons have been replaced with the given value.
}
\description{
Substitute Epsilon with a given value.
}
\details{
For details see the given references.
}
\examples{


graph <- improvedParallelGatekeeping()
graph
substituteEps(graph, eps=0.01)


}
\seealso{
\code{\link{graphMCP}}, \code{\link{entangledMCP}}
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\keyword{graphs}
\keyword{print}
