/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.af.commons.widgets.buttons.OkCancelButtonPane;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.graph.GraphView;

public class RearrangeNodesDialog
extends JDialog
implements ActionListener {
    OkCancelButtonPane pane = new OkCancelButtonPane();
    protected JRadioButton jrbCircle = new JRadioButton("Arrange on a circle");
    protected JRadioButton jrbMatrix = new JRadioButton("Arrange as matrix");
    JSpinner tfRows;
    JSpinner tfCols;
    JCheckBox jByRow = new JCheckBox("place by row");
    GraphView control;

    public RearrangeNodesDialog(CreateGraphGUI mainFrame) {
        super((Frame)mainFrame, "Specify layout for nodes");
        this.control = mainFrame.getGraphView();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 10;
        c.ipady = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ButtonGroup group = new ButtonGroup();
        group.add(this.jrbCircle);
        group.add(this.jrbMatrix);
        this.jrbCircle.addActionListener(this);
        this.jrbMatrix.addActionListener(this);
        int n = mainFrame.getGraphView().getNL().getNodes().size();
        this.tfRows = new JSpinner(new SpinnerNumberModel(Math.round(Math.sqrt(n)), 1.0, (double)n, 1.0));
        this.tfCols = new JSpinner(new SpinnerNumberModel(Math.round(Math.sqrt(n) + 1.0), 1.0, (double)n, 1.0));
        this.jrbMatrix.setSelected(true);
        this.getContentPane().add((Component)this.jrbCircle, c);
        ++c.gridy;
        this.getContentPane().add((Component)this.jrbMatrix, c);
        ++c.gridy;
        this.getContentPane().add((Component)new JLabel("Number of rows"), c);
        ++c.gridx;
        this.getContentPane().add((Component)this.tfRows, c);
        ++c.gridy;
        c.gridx = 0;
        this.getContentPane().add((Component)new JLabel("Number of columns"), c);
        ++c.gridx;
        this.getContentPane().add((Component)this.tfCols, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridx = 1;
        this.getContentPane().add((Component)this.jByRow, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridx = 1;
        c.gridwidth = 2;
        this.pane.addActionListener((ActionListener)this);
        this.getContentPane().add((Component)this.pane, c);
        this.pack();
        this.setLocationRelativeTo(mainFrame);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jrbCircle || e.getSource() == this.jrbMatrix) {
            this.enableButtons(this.jrbMatrix.isSelected());
        }
        if (e.getActionCommand().equals("OK")) {
            String rows = this.tfRows.getModel().getValue().toString();
            String cols = this.tfCols.getModel().getValue().toString();
            String byrow = this.jByRow.isSelected() ? "TRUE" : "FALSE";
            String layout = this.jrbCircle.isSelected() ? "" : ", nrow=" + rows + ", ncol=" + cols + ", byrow = " + byrow;
            String graphName = ".tmpGraph" + new Date().getTime();
            this.control.getNL().saveGraph(graphName, false);
            RControl.getR().eval(graphName + " <- placeNodes(" + graphName + layout + ", force = TRUE)");
            this.control.getNL().loadGraph(graphName);
            this.dispose();
        }
        if (e.getActionCommand().equals("CANCEL")) {
            this.dispose();
        }
    }

    private void enableButtons(boolean selected) {
        this.tfRows.setEnabled(selected);
        this.tfCols.setEnabled(selected);
        this.jByRow.setEnabled(selected);
    }
}

