/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.af.commons.widgets.validate.RealTextField;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.VariableNameDialog;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.Node;
import org.mutoss.gui.JavaGDPanel;

public class DialogConfIntEstVar
extends JDialog
implements ActionListener,
ChangeListener,
DocumentListener {
    List<JLabel> names = new Vector<JLabel>();
    List<JLabel> alphaLabel = new Vector<JLabel>();
    List<JLabel> ci = new Vector<JLabel>();
    List<JSpinner> df = new Vector<JSpinner>();
    List<RealTextField> est = new Vector<RealTextField>();
    List<RealTextField> var = new Vector<RealTextField>();
    List<JComboBox> alt = new Vector<JComboBox>();
    List<JComboBox> dist = new Vector<JComboBox>();
    String[] dists = new String[]{"normal-distributed", "t-distributed"};
    String[] alternatives = new String[]{"less", "greater"};
    JButton jbLoadEst = new JButton("Load \u00b5 from R");
    JButton jbLoadSD = new JButton("Load sd from R");
    NetList nl;
    JFrame p;
    boolean[] rejected;
    double[] alpha;
    DecimalFormat format = Configuration.getInstance().getGeneralConfig().getDecFormat();

    public DialogConfIntEstVar(JFrame p, NetList nl, boolean[] rejected, double[] alpha) {
        super(p, "Confidence intervals", true);
        this.p = p;
        this.nl = nl;
        this.alpha = alpha;
        this.rejected = rejected;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)new JScrollPane(this.getPanel()), c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabel label = new JLabel("Confidence Intervals:");
        this.getContentPane().add((Component)label, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        RControl.getR().eval("JavaGD()");
        this.getContentPane().add((Component)new JScrollPane(this.getCIPanel()), c);
        ++c.gridy;
        c.weighty = 1.0;
        this.getContentPane().add((Component)new JavaGDPanel(), c);
        this.pack();
        this.setLocationRelativeTo(p);
        this.setVisible(true);
    }

    private JPanel getCIPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.setLayout(new GridBagLayout());
        for (int i = 0; i < this.nl.getNodes().size(); ++i) {
            Node node = this.nl.getNodes().get(i);
            c.gridx = 0;
            JLabel hypothesis = new JLabel(node.getName() + ":");
            panel.add((Component)hypothesis, c);
            ++c.gridx;
            JLabel ci = new JLabel("]" + this.format.format(Double.NEGATIVE_INFINITY) + "," + this.format.format(Double.POSITIVE_INFINITY) + "[");
            this.ci.add(ci);
            panel.add((Component)ci, c);
            ++c.gridx;
            ++c.gridy;
        }
        this.calculateCI();
        return panel;
    }

    private void calculateCI() {
        int n = this.nl.getNodes().size();
        double[] rLB = new double[n];
        double[] rUB = new double[n];
        double[] rEst = new double[n];
        for (int i = 0; i < n; ++i) {
            Double ub;
            Double lb;
            String d1 = "qnorm(";
            String d2 = ",)";
            if (this.dist.get(i).getSelectedItem().equals(this.dists[1])) {
                d1 = "qt(";
                d2 = "," + Integer.parseInt(this.df.get(i).getValue().toString()) + ")";
            }
            if (this.alt.get(i).getSelectedItem().equals("greater")) {
                lb = RControl.getR().eval(d1 + this.alpha[i] + d2).asRNumeric().getData()[0];
                ub = Double.POSITIVE_INFINITY;
            } else if (this.alt.get(i).getSelectedItem().equals("less")) {
                lb = Double.NEGATIVE_INFINITY;
                ub = RControl.getR().eval(d1 + (1.0 - this.alpha[i]) + d2).asRNumeric().getData()[0];
            } else {
                lb = RControl.getR().eval(d1 + this.alpha[i] / 2.0 + d2).asRNumeric().getData()[0];
                ub = RControl.getR().eval(d1 + (1.0 - this.alpha[i] / 2.0) + d2).asRNumeric().getData()[0];
            }
            try {
                Double ste = (Double)this.var.get(i).getValidatedValue();
                Double pEst = (Double)this.est.get(i).getValidatedValue();
                double lb2 = pEst + lb * ste;
                double ub2 = pEst + ub * ste;
                if (this.alt.get(i).getSelectedItem().equals("greater")) {
                    if (this.rejected[i]) {
                        lb2 = Math.max(lb2, 0.0);
                    }
                } else if (this.alt.get(i).getSelectedItem().equals("less") && this.rejected[i]) {
                    ub2 = Math.min(ub2, 0.0);
                }
                rLB[i] = lb2;
                rUB[i] = ub2;
                rEst[i] = pEst;
                this.ci.get(i).setText("]" + this.format.format(lb2) + "," + this.format.format(ub2) + "[");
                continue;
            }
            catch (ValidationException e) {
                this.ci.get(i).setText("Please specify a real decimal number for the estimate!");
            }
        }
        RControl.getR().eval("plotSimCI(cbind(" + RControl.getRString(rLB) + ", " + RControl.getRString(rEst) + ", " + RControl.getRString(rUB) + "))");
    }

    public JPanel getPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JLabel("Hypotheses"), c);
        ++c.gridx;
        panel.add((Component)new JLabel("Initial weights"), c);
        ++c.gridx;
        panel.add((Component)new JLabel("Estimate"), c);
        ++c.gridx;
        panel.add((Component)new JLabel("Standard error/deviation"), c);
        ++c.gridx;
        panel.add((Component)new JLabel("Distribution"), c);
        ++c.gridx;
        panel.add((Component)new JLabel("df"), c);
        ++c.gridx;
        panel.add((Component)new JLabel("Alternative"), c);
        ++c.gridy;
        for (Node node : this.nl.getNodes()) {
            c.gridx = 0;
            JLabel hypothesis = new JLabel(node.getName() + ":");
            this.names.add(hypothesis);
            panel.add((Component)hypothesis, c);
            ++c.gridx;
            JLabel alpha = new JLabel("\u03b1=" + this.format.format(node.getWeight()));
            this.alphaLabel.add(alpha);
            panel.add((Component)alpha, c);
            ++c.gridx;
            RealTextField estimate = new RealTextField("Point estimate");
            estimate.setColumns(8);
            estimate.setText("0");
            estimate.getDocument().addDocumentListener(this);
            this.est.add(estimate);
            panel.add((Component)estimate, c);
            ++c.gridx;
            RealTextField ste = new RealTextField("Standard error");
            ste.setColumns(8);
            ste.setText("1");
            ste.getDocument().addDocumentListener(this);
            this.var.add(ste);
            panel.add((Component)ste, c);
            ++c.gridx;
            JComboBox<String> dist = new JComboBox<String>(this.dists);
            dist.addActionListener(this);
            this.dist.add(dist);
            panel.add(dist, c);
            ++c.gridx;
            SpinnerNumberModel dfModel = new SpinnerNumberModel(9, 1, Integer.MAX_VALUE, 1);
            JSpinner df = new JSpinner(dfModel);
            ((JSpinner.DefaultEditor)df.getEditor()).getTextField().setColumns(4);
            df.setEnabled(dist.getSelectedItem().equals(this.dists[1]));
            this.df.add(df);
            df.addChangeListener(this);
            c.weightx = 0.0;
            panel.add((Component)df, c);
            c.weightx = 1.0;
            ++c.gridx;
            JComboBox<String> alt = new JComboBox<String>(this.alternatives);
            alt.addActionListener(this);
            this.alt.add(alt);
            panel.add(alt, c);
            ++c.gridx;
            ++c.gridy;
        }
        c.gridx = 0;
        ++c.gridx;
        ++c.gridx;
        panel.add((Component)this.jbLoadEst, c);
        this.jbLoadEst.addActionListener(this);
        ++c.gridx;
        panel.add((Component)this.jbLoadSD, c);
        this.jbLoadSD.addActionListener(this);
        ++c.gridx;
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().getClass().equals(JComboBox.class)) {
            int i = this.dist.indexOf(e.getSource());
            if (i != -1) {
                this.df.get(i).setEnabled(this.dist.get(i).getSelectedItem().equals(this.dists[1]));
            }
        } else if (e.getSource().getClass().equals(JButton.class)) {
            VariableNameDialog vnd = new VariableNameDialog(this.p, "");
            try {
                double[] data = RControl.getR().eval(vnd.getName()).asRNumeric().getData();
                if (data.length != this.names.size()) {
                    JOptionPane.showMessageDialog(this, "Number of hypotheses and values do not match.", "Number of hypotheses and values do not match", 0);
                    return;
                }
                if (this.jbLoadEst.equals(e.getSource())) {
                    for (int i = 0; i < data.length; ++i) {
                        this.est.get(i).setText("" + data[i]);
                    }
                } else if (this.jbLoadSD.equals(e.getSource())) {
                    for (int i = 0; i < data.length; ++i) {
                        this.var.get(i).setText("" + data[i]);
                    }
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Error loading values from R:\n" + ex.getMessage(), "Error loading values from R", 0);
            }
        }
        this.calculateCI();
    }

    public void stateChanged(ChangeEvent e) {
        this.calculateCI();
    }

    public void changedUpdate(DocumentEvent e) {
        this.calculateCI();
    }

    public void insertUpdate(DocumentEvent e) {
        this.calculateCI();
    }

    public void removeUpdate(DocumentEvent e) {
        this.calculateCI();
    }
}

