% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{lasso_select}
\alias{lasso_select}
\title{Configure Lasso Select Behavior}
\usage{
lasso_select(
  key = "lasso-select",
  animation = FALSE,
  enable = TRUE,
  enableElements = "node",
  immediately = FALSE,
  mode = c("default", "union", "intersect", "diff"),
  onSelect = NULL,
  state = "selected",
  style = NULL,
  trigger = c("shift"),
  ...
)
}
\arguments{
\item{key}{Unique identifier for the behavior (string, default: "lasso-select").}

\item{animation}{Whether to enable animation (boolean, default: FALSE).}

\item{enable}{Whether to enable lasso selection (boolean or JS function, default: TRUE).}

\item{enableElements}{Types of elements that can be selected (character vector, default: c("node", "combo", "edge")).}

\item{immediately}{Whether to select immediately, only effective when selection mode is default (boolean, default: FALSE).}

\item{mode}{Selection mode: "union", "intersect", "diff", or "default" (string, default: "default").}

\item{onSelect}{Callback for selected element state (JS function, default: NULL).}

\item{state}{State to switch to when selected (string, default: "selected").}

\item{style}{Style of the lasso during selection (list, default: NULL).}

\item{trigger}{Press this shortcut key along with mouse click to select (character vector, default: c("shift")).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/lasso-select}.}
}
\value{
A list with the configuration settings for the lasso-select behavior.
}
\description{
Creates a configuration object for the lasso-select behavior in G6.
This behavior allows selecting elements by drawing a lasso around them.
}
\examples{
# Basic configuration
config <- lasso_select()

# Custom configuration
config <- lasso_select(
  key = "my-lasso-select",
  animation = TRUE,
  enableElements = c("node", "combo"),
  mode = "union",
  state = "highlight",
  trigger = c("control"),
  style = list(
    stroke = "#1890FF",
    lineWidth = 2,
    fillOpacity = 0.1
  )
)
}
