% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.fuzzylm.R
\name{print.summary.fuzzylm}
\alias{print.summary.fuzzylm}
\title{Prints Fuzzy Linear Regression Summary}
\usage{
\method{print}{summary.fuzzylm}(x, ...)
}
\arguments{
\item{x}{a summary of a \code{fuzzylm} object.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Prints the models for the central tendency and spreads from the \code{fuzzylm} object.
}
\examples{
x <- rep(1:3, each = 5)
y <- c(rnorm(5, 1), rnorm(5, 2), rnorm(5, 3))
dat <- data.frame(x = x, y = y)
f <- fuzzylm(y ~ x, dat)
sum.f <- summary(f)
sum.f
}
\keyword{fuzzy}
