% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{future.batchtools.options}
\alias{future.batchtools.options}
\alias{future.cache.path}
\alias{future.batchtools.expiration.tail}
\alias{future.batchtools.output}
\alias{future.batchtools.workers}
\alias{R_FUTURE_BATCHTOOLS_WORKERS}
\alias{R_FUTURE_FUTURE_CACHE_PATH}
\title{Options used for batchtools futures}
\description{
Below are the \R options and environment variables that are used by the
\pkg{future.batchtools} package.
See \link[future:future.options]{future::future.options} for additional ones that apply to futures
in general.\cr
\cr
\emph{WARNING: Note that the names and the default values of these options may change in future versions of the package.  Please use with care until further notice.}
}
\section{Settings for batchtools futures}{

\describe{
\item{\option{future.batchtools.workers}:}{(a positive numeric or \code{+Inf})
The default number of workers available on HPC schedulers with
job queues.  If not set, the value of the
\env{R_FUTURE_BATCHTOOLS_WORKERS} environment variable is used.
(Default: \code{100})}

\item{\option{future.batchtools.output}:}{(logical)
If TRUE, \pkg{batchtools} will produce extra output.
If FALSE, such output will be disabled by setting \pkg{batchtools}
options \option{batchtools.verbose} and \option{batchtools.progress}
to FALSE.
(Default: \code{getOption("future.debug", FALSE)})}

\item{\option{future.batchtools.expiration.tail}:}{(a positive numeric)
When a \pkg{batchtools} job expires, the last few lines will be
relayed by batchtools futures to help troubleshooting.
This option controls how many lines are displayed.
(Default: \code{48L})}

\item{\option{future.cache.path} / \env{R_FUTURE_CACHE_PATH}}{
(character string)
An absolute or relative path specifying the root folder in which
\pkg{batchtools} registry folders are stored.
(Default: \code{.future})}
}
}

\keyword{internal}
