% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_Map.R, R/future_mapply.R
\name{future_Map}
\alias{future_Map}
\alias{future_mapply}
\title{Apply a Function to Multiple List or Vector Arguments}
\usage{
future_Map(f, ...)

future_mapply(FUN, ..., MoreArgs = NULL, SIMPLIFY = TRUE,
  USE.NAMES = TRUE, future.stdout = TRUE,
  future.conditions = c("message", "warning"), future.globals = TRUE,
  future.packages = NULL, future.lazy = FALSE, future.seed = FALSE,
  future.scheduling = 1, future.chunk.size = NULL)
}
\arguments{
\item{f}{A function of the arity \eqn{k} if \code{future_Map()} is called with
\eqn{k} arguments.}

\item{FUN}{A function to apply, found via \code{\link[base:match.fun]{base::match.fun()}}.}

\item{MoreArgs}{A list of other arguments to \code{FUN}.}

\item{SIMPLIFY}{A logical or character string; attempt to reduce the
result to a vector, matrix or higher dimensional array; see the simplify
argument of \code{\link[base:sapply]{base::sapply()}}.}

\item{USE.NAMES}{A logical; use names if the first \code{\ldots} argument has
names, or if it is a character vector, use that character vector as the
names.}

\item{future.stdout}{If \code{TRUE} (default), then the standard output of the
underlying futures is captured, and re-outputted as soon as possible.
If \code{FALSE}, any output is silenced (by sinking it to the null device
as it is outputted).
If \code{NA} (not recommended), output is \emph{not} intercepted.}

\item{future.conditions}{A character string of conditions classes to be
captured and relayed.  The default is to relay messages and warnings.
To not intercept conditions, use \code{conditions = character(0L)}.
Errors are always relayed.}

\item{future.globals}{A logical, a character vector, or a named list for
controlling how globals are handled.
For details, see \code{\link[=future_lapply]{future_lapply()}}.}

\item{future.packages}{(optional) a character vector specifying packages
to be attached in the R environment evaluating the future.}

\item{future.lazy}{Specifies whether the futures should be resolved
lazily or eagerly (default).}

\item{future.seed}{A logical or an integer (of length one or seven), or
a list of \code{max(lengths(list(...)))} with pre-generated random seeds.
For details, see \code{\link[=future_lapply]{future_lapply()}}.}

\item{future.scheduling}{Average number of futures ("chunks") per worker.
If \code{0.0}, then a single future is used to process all elements
of \code{X}.
If \code{1.0} or \code{TRUE}, then one future per worker is used.
If \code{2.0}, then each worker will process two futures
(if there are enough elements in \code{X}).
If \code{Inf} or \code{FALSE}, then one future per element of
\code{X} is used.
Only used if \code{future.chunk.size} is \code{NULL}.}

\item{future.chunk.size}{The average number of elements per future ("chunk").
If \code{Inf}, then all elements are processed in a single future.
If \code{NULL}, then argument \code{future.scheduling} is used.}

\item{\ldots}{Arguments to vectorize over (vectors or lists of strictly
positive length, or all of zero length).}
}
\value{
\code{future_Map()} is a simple wrapper to \code{future_mapply()} which does not
attempt to simplify the result.
See \code{\link[base:Map]{base::Map()}} for details.

\code{future_mapply() returns a list, or for }SIMPLIFY = TRUE`, a vector,
array or list.  See \code{\link[base:mapply]{base::mapply()}} for details.
}
\description{
\code{future_mapply()} implements \code{\link[base:mapply]{base::mapply()}} using futures with perfect
replication of results, regardless of future backend used.
Analogously to \code{mapply()}, \code{future_mapply()} is a multivariate version of
\code{future_sapply()}.
It applies \code{FUN} to the first elements of each \code{\ldots} argument,
the second elements, the third elements, and so on.
Arguments are recycled if necessary.
}
\examples{
## ---------------------------------------------------------
## mapply()
## ---------------------------------------------------------
y0 <- mapply(rep, 1:4, 4:1)
y1 <- future_mapply(rep, 1:4, 4:1)
stopifnot(identical(y1, y0))

y0 <- mapply(rep, times = 1:4, x = 4:1)
y1 <- future_mapply(rep, times = 1:4, x = 4:1)
stopifnot(identical(y1, y0))

y0 <- mapply(rep, times = 1:4, MoreArgs = list(x = 42))
y1 <- future_mapply(rep, times = 1:4, MoreArgs = list(x = 42))
stopifnot(identical(y1, y0))

y0 <- mapply(function(x, y) seq_len(x) + y,
             c(a =  1, b = 2, c = 3),  # names from first
             c(A = 10, B = 0, C = -10))
y1 <- future_mapply(function(x, y) seq_len(x) + y,
                    c(a =  1, b = 2, c = 3),  # names from first
                    c(A = 10, B = 0, C = -10))
stopifnot(identical(y1, y0))

word <- function(C, k) paste(rep.int(C, k), collapse = "")
y0 <- mapply(word, LETTERS[1:6], 6:1, SIMPLIFY = FALSE)
y1 <- future_mapply(word, LETTERS[1:6], 6:1, SIMPLIFY = FALSE)
stopifnot(identical(y1, y0))


## ---------------------------------------------------------
## Parallel Random Number Generation
## ---------------------------------------------------------
\donttest{
## Regardless of the future plan, the number of workers, and
## where they are, the random numbers produced are identical

plan(multiprocess)
y1 <- future_mapply(stats::runif, n = 1:4, max = 2:5,
                    MoreArgs = list(min = 1), future.seed = 0xBEEF)
print(y1)

plan(sequential)
y2 <- future_mapply(stats::runif, n = 1:4, max = 2:5,
                    MoreArgs = list(min = 1), future.seed = 0xBEEF)
print(y2)

stopifnot(all.equal(y1, y2))
}
}
\author{
The implementations of \code{future_Map()} is adopted from the source code
of the corresponding base \R function \code{Map()}, which is licensed under
GPL (>= 2) with 'The R Core Team' as the copyright holder.
}
\keyword{iteration}
\keyword{manip}
\keyword{programming}
