% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchjobs_multicore.R
\name{batchjobs_multicore}
\alias{batchjobs_multicore}
\title{BatchJobs multicore futures}
\usage{
batchjobs_multicore(expr, envir = parent.frame(), substitute = TRUE,
  globals = TRUE, label = "BatchJobs",
  workers = availableCores(constraints = "multicore"),
  job.delay = FALSE, ...)
}
\arguments{
\item{expr}{The R expression to be evaluated}

\item{envir}{The environment in which global environment
should be located.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}

\item{globals}{(optional) a logical, a character vector, a named list, or a \link[globals]{Globals} object.  If TRUE, globals are identified by code inspection based on \code{expr} and \code{tweak} searching from environment \code{envir}.  If FALSE, no globals are used.  If a character vector, then globals are identified by lookup based their names \code{globals} searching from environment \code{envir}.  If a named list or a Globals object, the globals are used as is.}

\item{label}{(optional) Label of the future (where applicable, becomes the job name for most job schedulers).}

\item{workers}{The number of multicore processes to be
available for concurrent BatchJobs multicore futures.}

\item{job.delay}{(optional) Passed as is to \code{\link[BatchJobs]{submitJobs}()}.}

\item{\ldots}{Additional arguments passed
to \code{\link{BatchJobsFuture}()}.}
}
\value{
An object of class \code{BatchJobsFuture}.
}
\description{
A BatchJobs multicore future is an asynchronous multiprocess
future that will be evaluated in a background R session.\cr
\cr
\emph{We highly recommend using \code{\link[future]{multisession}}
(sic!) futures of the \pkg{future} package instead of
multicore BatchJobs futures.}
}
\details{
BatchJobs multicore futures rely on the BatchJobs backend set
up by \code{\link[BatchJobs]{makeClusterFunctionsMulticore}()}.
The BatchJobs multicore backend only works on operating systems
supporting the \code{ps} command-line tool, e.g. Linux and OS X.
However, they are not supported on neither Windows nor Solaris
Unix (because \code{ps -o ucomm=} is not supported).  When not
supported, it falls back to \code{\link{batchjobs_local}}.

\emph{Warning: For multicore BatchJobs, the \pkg{BatchJobs}
package uses a built-in algorithm for load balancing based on
other processes running on the same machine.  This is done
in order to prevent the machine's CPU load to blow up.
Unfortunately, the BatchJobs criteria for handling this often
results in starvation, that is, long waiting times before
launching jobs.  The risk for this is particularly high if
there are other R processes running on the same machine
including those by other users.
See also \url{https://github.com/tudo-r/BatchJobs/issues/99}.
\bold{Conclusion:} We highly recommend using
\code{\link[future]{multisession}} futures of the
\pkg{future} package instead of multicore BatchJobs futures.}

Also, despite the name, BatchJobs multicore futures are in
function closer related to \link[future:multisession]{multisession}
futures than \link[future:multicore]{multicore} futures,
both provided by the \pkg{future} package.  This is because
BatchJobs spawns off background R sessions rather than forking
the current R process as the name otherwise might imply (at least
that is how the term "multicore processing" is typically used
in the R world).
}
\keyword{internal}
