% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchjobs_local.R
\name{batchjobs_local}
\alias{batchjobs_interactive}
\alias{batchjobs_local}
\title{BatchJobs local and interactive futures}
\usage{
batchjobs_local(expr, envir = parent.frame(), substitute = TRUE, ...)
}
\arguments{
\item{expr}{An R expression to be evaluated.}

\item{envir}{The environment from which global environment
are search from.}

\item{substitute}{Controls whether \code{expr} should be
\code{substitute()}:d or not.}

\item{\ldots}{Additional arguments passed to \code{\link{BatchJobsFuture}()}.}
}
\value{
An object of class \code{BatchJobsFuture}.
}
\description{
A BatchJobs local future is an synchronous uniprocess future that
will be evaluated in a background R session.
A BatchJobs interactive future is an synchronous uniprocess future
that will be evaluated in the current R session (and variables will
be assigned to the calling environment rather than to a local one).
Both types of futures will block until the futures are resolved.
}
\details{
BatchJobs local futures rely on the BatchJobs backend set
up by \code{\link[BatchJobs]{makeClusterFunctionsLocal}()}
and BatchJobs interactive futures on the one set up by
\code{\link[BatchJobs]{makeClusterFunctionsInteractive}()}.
These are supported by all operating systems.

An alternative to BatchJobs local futures is to use
\link[future:cluster]{cluster} futures of the \pkg{future}
package with a single local background session, i.e.
\code{plan(cluster, workers="localhost")}.

An alternative to BatchJobs interactive futures is to use
\link[future:transparent]{transparent} futures of the
\pkg{future} package.
}
\examples{
## Use local BatchJobs futures
plan(batchjobs_local)

## A global variable
a <- 1

## Create explicit future
f <- future({
  b <- 3
  c <- 2
  a * b * c
})
v <- value(f)
print(v)


## Create implicit future
v \%<-\% {
  b <- 3
  c <- 2
  a * b * c
}
print(v)
}

