% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinctiveness.R
\name{distinctiveness_com}
\alias{distinctiveness_com}
\title{Functional Distinctiveness for a single community}
\usage{
distinctiveness_com(com_df, sp_col, abund = NULL, dist_matrix)
}
\arguments{
\item{com_df}{a stacked (= tidy) data.frame from a single community with each
row representing a species in a community}

\item{sp_col}{a character vector, the name of the species column in \code{com_df}}

\item{abund}{a character vector, the name of the column containing relative
abundances values}

\item{dist_matrix}{a functional distance matrix as given by
\code{compute_dist_matrix()}, with species name as row and column names}
}
\value{
the same data.frame with the additional \strong{Di} column giving
functional distinctiveness values for each species
}
\description{
Given a stacked data.frame and a distance matrix compute the functional
distinctiveness for a single community. Functional distinctiveness relates to
the functional "originality" of a species in a community. The closer to 1 the
more the species is functionally distinct from the rest of the community. See
\code{\link[=distinctiveness]{distinctiveness()}} function or the functional rarity
indices vignette included in the package
(type \code{vignette("rarity_indices", package = "funrar")}), for more details
on the metric. \strong{IMPORTANT NOTE}: in order to get functional rarity indices
between 0 and 1, the distance metric has to be scaled between 0 and 1.
}
\section{Caution}{

This function is meant for internal uses mostly, thus it does not include any
tests on inputs and may fail unexpectedly. Please use
\code{\link[=distinctiveness_stack]{distinctiveness_stack()}} to avoid input errors.
}

\seealso{
\code{\link[=scarcity_com]{scarcity_com()}},
\code{vignette("rarity_indices", package = "funrar")} and
\code{\link[=distinctiveness]{distinctiveness()}} Details section for detail on the index
}
