% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real_time_02_sof_pc.R
\name{sof_pc_real_time}
\alias{sof_pc_real_time}
\title{Get a list of scalar-on-function linear regression models estimated
on functional data
each evolving up to an intermediate domain point.}
\usage{
sof_pc_real_time(
  y,
  mfd_real_time_list,
  single_min_variance_explained = 0,
  tot_variance_explained = 0.9,
  selection = "PRESS",
  components = NULL,
  ncores = 1
)
}
\arguments{
\item{y}{A numeric vector containing the observations of
the scalar response variable.}

\item{mfd_real_time_list}{A list created using
\code{\link{get_mfd_df_real_time}} or
\code{get_mfd_list_real_time}, denoting a list of functional data objects,
each evolving up to an intermediate domain point,
with observations of the multivariate functional covariates.}

\item{single_min_variance_explained}{See \code{\link{sof_pc}}.}

\item{tot_variance_explained}{See \code{\link{sof_pc}}.}

\item{selection}{See \code{\link{sof_pc}}.}

\item{components}{See \code{\link{sof_pc}}.}

\item{ncores}{If you want parallelization, give the number of cores/threads
to be used when creating objects separately for different instants.}
}
\value{
A list of lists each produced by \code{\link{sof_pc}},
corresponding to a given instant.
}
\description{
This function produces a list of objects,
each of them contains the result of applying \code{\link{sof_pc}} to
a scalar response variable and multivariate functional covariates
evolved up to an intermediate domain point.
See Capezza et al. (2020) for additional details on real-time monitoring.
}
\examples{
library(funcharts)
data("air")
air <- lapply(air, function(x) x[1:10, , drop = FALSE])
mfdobj_list <- get_mfd_list_real_time(air[c("CO", "temperature")],
                                      n_basis = 15,
                                      lambda = 1e-2,
                                      k_seq = c(0.5, 0.75, 1))
y <- rowMeans(air$NO2)
mod_list <- sof_pc_real_time(y, mfdobj_list)

}
\references{
Capezza C, Lepore A, Menafoglio A, Palumbo B, Vantini S. (2020)
Control charts for
monitoring ship operating conditions and CO2 emissions
based on scalar-on-function regression.
\emph{Applied Stochastic Models in Business and Industry},
36(3):477--500. \url{doi:10.1002/asmb.2507}
}
\seealso{
\code{\link{sof_pc}},
\code{\link{get_mfd_df_real_time}},
\code{\link{get_mfd_list_real_time}}
}
