% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_phaseII.R
\name{regr_cc_sof}
\alias{regr_cc_sof}
\title{Scalar-on-Function Regression Control Chart}
\usage{
regr_cc_sof(
  object,
  y_new,
  mfdobj_x_new,
  y_tuning = NULL,
  mfdobj_x_tuning = NULL,
  alpha = 0.05,
  parametric_limits = FALSE,
  include_covariates = FALSE,
  absolute_error = FALSE
)
}
\arguments{
\item{object}{A list obtained as output from \code{sof_pc},
i.e. a fitted scalar-on-function linear regression model.}

\item{y_new}{A numeric vector containing the observations of
the scalar response variable
in the phase II data set.}

\item{mfdobj_x_new}{An object of class \code{mfd} containing
the phase II data set of the functional covariates observations.}

\item{y_tuning}{A numeric vector containing the observations of the scalar response
variable in the tuning data set.
If NULL, the training data, i.e. the data used to
fit the scalar-on-function regression model,
are also used as the tuning data set.
Default is NULL.}

\item{mfdobj_x_tuning}{An object of class \code{mfd} containing
the tuning set of the multivariate functional data, used to estimate the
control chart limits.
If NULL, the training data, i.e. the data used to
fit the scalar-on-function regression model,
are also used as the tuning data set.
Default is NULL.}

\item{alpha}{If it is a number between 0 and 1,
it defines the overall type-I error probability.
If \code{include_covariates} is \code{TRUE}, i.e.,
also the Hotelling's T2 and SPE control charts are built
on the functional covariates, then the Bonferroni
correction is applied by setting the type-I error probability
in the three control charts equal to \code{alpha/3}.
In this last case,
if you want to set manually the Type-I error probabilities,
then the argument \code{alpha} must be a named list
with three elements, named \code{T2}, \code{spe} and \code{y},
respectively, each containing
the desired Type I error probability of
the corresponding control chart, where \code{y} refers to the
regression control chart.
Default value is 0.05.}

\item{parametric_limits}{If \code{TRUE}, the limits are calculated based on the normal distribution
assumption on the response variable, as in Capezza et al. (2020).
If \code{FALSE}, the limits are calculated nonparametrically as
empirical quantiles of the distribution of the residuals calculated
on the tuning data set.
The default value is \code{FALSE}.}

\item{include_covariates}{If TRUE, also functional covariates are monitored through
 \code{control_charts_pca},.
If FALSE, only the scalar response, conditionally on the covariates,
is monitored.}

\item{absolute_error}{A logical value that, if \code{include_covariates} is TRUE, is passed
to \code{\link{control_charts_pca}}.}
}
\value{
A \code{data.frame} with as many rows as the
number of functional replications in \code{mfdobj_x_new},
with the following columns:

* \code{y_hat}: the predictions of the response variable
corresponding to \code{mfdobj_x_new},

* \code{y}: the same as the argument \code{y_new} given as input
to this function,

* \code{lwr}: lower limit of the \code{1-alpha} prediction interval
on the response,

* \code{pred_err}: prediction error calculated as \code{y-y_hat},

* \code{pred_err_sup}: upper limit of the \code{1-alpha} prediction interval
on the prediction error,

* \code{pred_err_inf}: lower limit of the \code{1-alpha} prediction interval
on the prediction error.
}
\description{
This function is deprecated. Use \code{\link{regr_cc_sof}}.
This function builds a data frame needed
to plot the scalar-on-function regression control chart,
based on a fitted function-on-function linear regression model and
proposed in Capezza et al. (2020).
If \code{include_covariates} is \code{TRUE},
it also plots the Hotelling's T2 and
squared prediction error control charts built on the
multivariate functional covariates.
}
\details{
The training data have already been used to fit the model.
An additional tuning data set can be provided that is used to estimate
the control chart limits.
A phase II data set contains the observations to be monitored
with the built control charts.
}
\examples{
library(funcharts)
air <- lapply(air, function(x) x[1:100, , drop = FALSE])
fun_covariates <- c("CO", "temperature")
mfdobj_x <- get_mfd_list(air[fun_covariates],
                         n_basis = 15,
                         lambda = 1e-2)
y <- rowMeans(air$NO2)
y1 <- y[1:80]
y2 <- y[81:100]
mfdobj_x1 <- mfdobj_x[1:80]
mfdobj_x2 <- mfdobj_x[81:100]
mod <- sof_pc(y1, mfdobj_x1)
cclist <- regr_cc_sof(object = mod,
                      y_new = y2,
                      mfdobj_x_new = mfdobj_x2)
plot_control_charts(cclist)

}
\references{
Capezza C, Lepore A, Menafoglio A, Palumbo B, Vantini S. (2020)
Control charts for
monitoring ship operating conditions and CO2 emissions
based on scalar-on-function regression.
\emph{Applied Stochastic Models in Business and Industry},
36(3):477--500.
<doi:10.1002/asmb.2507>
}
