% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-frame.R
\name{quick_df}
\alias{quick_df}
\alias{empty_df}
\alias{quick_dfl}
\title{Quick DF}
\usage{
quick_df(x = NULL)

empty_df()

quick_dfl(...)
}
\arguments{
\item{x}{A list or \code{NULL} (see return)}

\item{...}{Columns as \code{tag = value} (passed to \code{list()})}
}
\value{
A \code{data.frame}; if \code{x} is \code{NULL} a \code{data.frame} with \code{0} rows and \code{0}
columns is returned (similar to calling \code{data.frame()} but faster).
\code{empty_df()} returns a \code{data.frame} with \code{0} rows and \code{0} columns.
}
\description{
This is a speedier implementation of \code{as.data.frame()} but does not provide
the same sort of checks. It should be used with caution.
}
\examples{
# unnamed will use make.names()
x <- list(1:10, letters[1:10])
quick_df(x)

# named is preferred
names(x) <- c("numbers", "letters")
quick_df(x)

# empty data.frame
empty_df() # or quick_df(NULL)

}
