% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsr_base.R
\name{PWKT}
\alias{PWKT}
\alias{spa_pwkt}
\alias{format.pgeometry}
\alias{show,pgeometry-method}
\alias{as.character,pgeometry-method}
\title{The PWKT of a spatial plateau object}
\usage{
spa_pwkt(pgo)

\method{format}{pgeometry}(x, ...)

\S4method{show}{pgeometry}(object)

\S4method{as.character}{pgeometry}(x, ...)
}
\arguments{
\item{pgo}{A \code{pgeometry} object of any type.}

\item{x}{A \code{pgeometry} object of any type.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Unused.}

\item{object}{A \code{pgeometry} object of any type.}
}
\value{
A character value with the textual representation of a given \code{pgeometry} object.
}
\description{
This function gives the Plateau Well-Known Text (PWKT) representation of a \code{pgeometry} object.
}
\details{
It gives the textual representation for a \code{pgeometry} object,
combining the Well-Known Text (WKT) representation for crisp vector geometry
objects and the formal definitions of the tree spatial plateau data types.
(i.e. \code{PLATEAUPOINT}, \code{PLATEAULINE}, \code{PLATEAUREGION}).
}
\examples{

library(sf)

# For a `PLATEAUPOINT` object.
pts1 <- rbind(c(1, 2), c(3, 2))
comp1 <- component_from_sfg(st_multipoint(pts1), 0.2) 
comp2 <- component_from_sfg(st_point(c(1, 5)), 0.8)  

ppoint <- create_pgeometry(list(comp1, comp2), "PLATEAUPOINT")

spa_pwkt(ppoint)

# For a `PLATEAULINE` object.

lpts1 <- rbind(c(0, 0), c(1, 1))
lpts2 <- rbind(c(1, 1), c(1.2, 1.9), c(2, 1))
lpts3 <- rbind(c(2, 1), c(1.5, 0.5))

comp4 <- component_from_sfg(st_linestring(lpts1), 0.4)
comp5 <- component_from_sfg(st_linestring(lpts2), 1)
comp6 <- component_from_sfg(st_linestring(lpts3), 0.7)

pline <- create_pgeometry(list(comp4, comp5, comp6), "PLATEAULINE")

spa_pwkt(pline)

# For a `PLATEAUREGION` object.

p1 <- rbind(c(0,0), c(1,0), c(3,2), c(2,4), c(1,4), c(0,0))
p2 <- rbind(c(1,1), c(1,2), c(2,2), c(1,1))
pol1 <-st_polygon(list(p1,p2))

comp1 <- component_from_sfg(pol1, 0.2)

pregion <- create_pgeometry(list(comp1), "PLATEAUREGION")

spa_pwkt(pregion)


}
\references{
\href{https://ieeexplore.ieee.org/document/8491565}{Carniel, A. C.; Schneider, M. Spatial Plateau Algebra: An Executable Type System for Fuzzy Spatial Data Types. In Proceedings of the 2018 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2018), pp. 1-8, 2018.}
}
